/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.printer.discovery.DiscoveryHandler;
import com.zebra.sdk.util.internal.JacksonObjectMapperFactory;
import com.zebra.sdk.util.internal.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CommandLineDiscoHandler
implements DiscoveryHandler {
    private List<DiscoveredPrinter> printers;
    private boolean isXML;
    private boolean isJson;
    private int numberOfDiscoveriesOccuring = 1;
    private int numberOfDiscoveriesFinished = 0;

    public CommandLineDiscoHandler(boolean bl, boolean bl2) {
        this.isXML = bl;
        this.isJson = bl2;
        this.printers = new ArrayList<DiscoveredPrinter>();
    }

    public void setNumberOfDiscoveriesOccuring(int n) {
        this.numberOfDiscoveriesOccuring = n;
    }

    @Override
    public void foundPrinter(DiscoveredPrinter discoveredPrinter) {
        this.printers.add(discoveredPrinter);
    }

    @Override
    public void discoveryFinished() {
        if (++this.numberOfDiscoveriesFinished == this.numberOfDiscoveriesOccuring) {
            if (this.isXML) {
                System.out.println(XmlUtil.xmlToString(this.createXMLDocument()));
            } else if (this.isJson) {
                System.out.println(this.getJsonDiscoData());
            } else {
                System.out.println(this.getPrinterAddresses());
            }
        }
    }

    protected String getJsonDiscoData() {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (DiscoveredPrinter discoveredPrinter : this.printers) {
            arrayList.add(discoveredPrinter.getDiscoveryDataMap());
        }
        try {
            return JacksonObjectMapperFactory.getInstance().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString(arrayList);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return jsonProcessingException.getLocalizedMessage();
        }
    }

    private String getPrinterAddresses() {
        StringBuilder stringBuilder = new StringBuilder();
        for (DiscoveredPrinter discoveredPrinter : this.printers) {
            stringBuilder.append(discoveredPrinter.address).append("\n");
        }
        return stringBuilder.toString();
    }

    private Element createXMLDocument() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement("DISCOVERED_PRINTERS");
            for (DiscoveredPrinter discoveredPrinter : this.printers) {
                Element element2 = document.createElement("PRINTER");
                Map<String, String> map = discoveredPrinter.getDiscoveryDataMap();
                for (String string : map.keySet()) {
                    Element element3 = document.createElement(string.trim());
                    element3.appendChild(document.createTextNode(map.get(string)));
                    element2.appendChild(element3);
                }
                element.appendChild(element2);
            }
            return element;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    @Override
    public void discoveryError(String string) {
        System.out.println("Discovery Error: " + string);
    }
}

