/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.NotALinkOsPrinterException;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.util.internal.Range;

public class DefaultSettingsCommand
extends Command {
    private static final Option PRINTER_OPTION = new Option("p", "printer", "Default printer");
    private static final Option NETWORK_OPTION = new Option("n", "network", "Default network");
    private static final Option ALL_OPTION = new Option("a", "all", "Default all");
    private static final int CONNECTION_ARG_INDEX = 0;

    public DefaultSettingsCommand() {
        this.options.add(PRINTER_OPTION);
        this.options.add(NETWORK_OPTION);
        this.options.add(ALL_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.groups.add(new OptionGroup().createGroup(PRINTER_OPTION, NETWORK_OPTION, ALL_OPTION));
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "default";
    }

    @Override
    public String getDescription() {
        return "Restore printer defaults.";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getArg(0);
        String string2 = this.getConnectionFromArgs(parsedArguments, string);
        if (parsedArguments.containsOption(PRINTER_OPTION)) {
            this.restoreDefaults(string, string2);
        } else if (parsedArguments.containsOption(NETWORK_OPTION)) {
            this.restoreNetworkDefaults(string, string2);
        } else if (parsedArguments.containsOption(ALL_OPTION)) {
            this.restoreDefaults(string, string2);
            this.restoreNetworkDefaults(string, string2);
        } else {
            System.out.println("Must specify printer, network, or all option.");
        }
    }

    private void restoreNetworkDefaults(String string, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        this.verboseFormatPrint("Restoring network defaults on %s%n", string);
        PrinterUtil.restoreNetworkDefaults(string2);
    }

    private void restoreDefaults(String string, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        this.verboseFormatPrint("Restoring print defaults on %s%n", string);
        PrinterUtil.restorePrinterDefaults(string2);
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.ONE_ARG_RANGE;
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Default the printer\n");
        stringBuilder.append(String.format("\t%s %s 192.168.1.2 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), PRINTER_OPTION.getLongName()));
        stringBuilder.append("Default the network\n");
        stringBuilder.append(String.format("\t%s %s 192.168.1.2 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), NETWORK_OPTION.getLongName()));
        stringBuilder.append("Default the printer and network\n");
        stringBuilder.append(String.format("\t%s %s 192.168.1.2 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ALL_OPTION.getLongName()));
        stringBuilder.append("Default the printer via ZDesigner Driver using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" --%s --%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), PRINTER_OPTION.getLongName(), ZebraCommandConstants.DRIVER_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Default the printer via Driverless USB using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" --%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), PRINTER_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        return stringBuilder.toString();
    }
}

