/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionBuilder;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.util.internal.Range;
import com.zebra.sdk.weblink.ConfigurationStatus;
import com.zebra.sdk.weblink.WeblinkAddressStrategy;
import com.zebra.sdk.weblink.WeblinkConfigurationState;
import com.zebra.sdk.weblink.WeblinkConfigurationStateUpdater;
import com.zebra.sdk.weblink.WeblinkConfigurator;
import java.util.HashMap;
import java.util.Map;

public class ConfigureWeblinkCommand
extends Command {
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int WEBLINK_ADDRESS_INDEX = 1;
    private static final Option FORCE_CONNECTION_1_OPTION = new Option("1", "force_location_1", "Force configuration of weblink location 1");
    private static final Option FORCE_CONNECTION_2_OPTION = new Option("2", "force_location_2", "Force configuration of weblink location 2");
    private static Map<WeblinkConfigurationState, String> messages = new HashMap<WeblinkConfigurationState, String>();
    protected Connection conn;

    public ConfigureWeblinkCommand() {
        this.options.add(FORCE_CONNECTION_1_OPTION);
        this.options.add(FORCE_CONNECTION_2_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "weblink";
    }

    @Override
    public String getDescription() {
        return "Configures the weblink address";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getArg(1);
        String string2 = this.getConnectionFromArgs(parsedArguments, parsedArguments.getArg(0));
        this.conn = this.createConnection(string2);
        final WeblinkConfigurator weblinkConfigurator = new WeblinkConfigurator(this.conn);
        WeblinkAddressStrategy weblinkAddressStrategy = WeblinkAddressStrategy.AUTO_SELECT;
        if (parsedArguments.containsOption(FORCE_CONNECTION_1_OPTION)) {
            weblinkAddressStrategy = WeblinkAddressStrategy.FORCE_CONNECTION_1;
        }
        if (parsedArguments.containsOption(FORCE_CONNECTION_2_OPTION)) {
            weblinkAddressStrategy = WeblinkAddressStrategy.FORCE_CONNECTION_2;
        }
        weblinkConfigurator.configure(string, weblinkAddressStrategy, new WeblinkConfigurationStateUpdater(){
            WeblinkConfigurationState lastState;

            @Override
            public void updateState(WeblinkConfigurationState weblinkConfigurationState) {
                if (weblinkConfigurator.getStatus() == ConfigurationStatus.IN_PROCESS) {
                    if (this.lastState == null || this.lastState != weblinkConfigurationState) {
                        this.lastState = weblinkConfigurationState;
                        ConfigureWeblinkCommand.this.verbosePrint((String)messages.get((Object)weblinkConfigurationState));
                    }
                } else if (weblinkConfigurator.getStatus() == ConfigurationStatus.SUCCESSFULLY_COMPLETED) {
                    ConfigureWeblinkCommand.this.verbosePrint("");
                    ConfigureWeblinkCommand.this.verbosePrint("Printer was successfully configured");
                }
            }

            @Override
            public void progressUpdate(String string) {
                ConfigureWeblinkCommand.this.verbosePrint(string);
            }
        });
    }

    protected Connection createConnection(String string) throws ConnectionException {
        return ConnectionBuilder.build(string);
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <URL> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Configure weblink via ZDesigner Driver\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" https://myserver/zebra/weblink/ --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("Configure weblink via network\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 https://myserver/zebra/weblink/ --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TCP_OPTION.getLongName()));
        stringBuilder.append("Configure weblink via network, forcing location 1, with verbose logging\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 https://myserver/zebra/weblink/ --%s -%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TCP_OPTION.getLongName(), "1", ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Configure weblink via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" https://myserver/zebra/weblink/%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }

    static {
        messages.put(WeblinkConfigurationState.ConnectToPrinter, "Connecting to printer");
        messages.put(WeblinkConfigurationState.GetSettings, "Retrieving settings");
        messages.put(WeblinkConfigurationState.ConfigureWeblink, "Configuring weblink settings");
        messages.put(WeblinkConfigurationState.RestartPrinter, "Restarting printer");
        messages.put(WeblinkConfigurationState.ReconnectToPrinter, "Connecting to printer");
        messages.put(WeblinkConfigurationState.VerifyWeblinkConnection, "Verifying connection to Zebra Weblink server");
    }
}

