/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.snmp.internal;

import com.zebra.sdk.comm.snmp.internal.OidNotFoundException;
import com.zebra.sdk.comm.snmp.internal.SnmpGet;
import com.zebra.sdk.comm.snmp.internal.SnmpPreferences;
import com.zebra.sdk.comm.snmp.internal.SnmpSet;
import com.zebra.sdk.comm.snmp.internal.SnmpTimeoutException;
import com.zebra.sdk.comm.snmp.internal.SnmpV1;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.settings.internal.SettingType;
import java.io.IOException;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.Pdu;

public class Snmp {
    private SnmpPreferences snmpPreferences = new SnmpPreferences();
    private SettingType type;

    public Snmp(String string, String string2, SettingType settingType) {
        this.snmpPreferences.setCommunityNameGet(string);
        this.snmpPreferences.setCommunityNameSet(string2);
        this.type = settingType;
    }

    public String get(String string, String string2) throws OidNotFoundException, SnmpTimeoutException {
        String string3 = "";
        SnmpV1 snmpV1 = null;
        try {
            snmpV1 = new SnmpGet(string, this.snmpPreferences);
            ((SnmpGet)snmpV1).init(string2);
            snmpV1.sendRequest();
            Pdu pdu = snmpV1.getPdu();
            pdu.waitForSelf();
            boolean bl = pdu.isTimedOut();
            if (bl) {
                throw new SnmpTimeoutException();
            }
            AsnObject asnObject = (AsnObject)snmpV1.getReturnValue();
            string3 = asnObject.toString();
        }
        catch (IOException iOException) {
            throw new OidNotFoundException(iOException.getLocalizedMessage());
        }
        finally {
            if (snmpV1 != null) {
                snmpV1.destroy();
            }
        }
        return string3;
    }

    public void set(String string, String string2, String string3) throws OidNotFoundException, ZebraIllegalArgumentException, SnmpTimeoutException {
        SnmpV1 snmpV1 = null;
        try {
            snmpV1 = new SnmpSet(string, this.snmpPreferences);
            if (this.type == SettingType.STRING) {
                ((SnmpSet)snmpV1).init(string2, new AsnOctets(string3));
            } else if (this.type == SettingType.ENUM || this.type == SettingType.INTEGER) {
                ((SnmpSet)snmpV1).init(string2, new AsnInteger(Integer.parseInt(string3)));
            } else {
                throw new ZebraIllegalArgumentException("Invalid setting type");
            }
            snmpV1.sendRequest();
            Pdu pdu = snmpV1.getPdu();
            pdu.waitForSelf();
            boolean bl = pdu.isTimedOut();
            snmpV1.destroy();
            if (bl) {
                throw new SnmpTimeoutException();
            }
        }
        catch (IOException iOException) {
            throw new OidNotFoundException(iOException.getLocalizedMessage());
        }
        finally {
            if (snmpV1 != null) {
                snmpV1.destroy();
            }
        }
    }
}

