/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.reedsolomon;

import jp.sourceforge.reedsolomon.Galois;

public class RsEncode {
    public static final int RS_PERM_ERROR = -1;
    private static final Galois galois = Galois.getInstance();
    private int npar;
    private int[] encodeGx;

    public RsEncode(int npar) {
        this.npar = npar;
        this.makeEncodeGx();
    }

    private void makeEncodeGx() {
        this.encodeGx = new int[this.npar];
        this.encodeGx[this.npar - 1] = 1;
        int kou = 0;
        while (kou < this.npar) {
            int ex = galois.toExp(kou);
            int i = 0;
            while (i < this.npar - 1) {
                this.encodeGx[i] = galois.mul(this.encodeGx[i], ex) ^ this.encodeGx[i + 1];
                ++i;
            }
            this.encodeGx[this.npar - 1] = galois.mul(this.encodeGx[this.npar - 1], ex);
            ++kou;
        }
    }

    public int encode(int[] data, int length, int[] parity, int parityStartPos) {
        if (length < 0 || length + this.npar > 255) {
            return -1;
        }
        int[] wr = new int[this.npar];
        int idx = 0;
        while (idx < length) {
            int code = data[idx];
            int ib = wr[0] ^ code;
            int i = 0;
            while (i < this.npar - 1) {
                wr[i] = wr[i + 1] ^ galois.mul(ib, this.encodeGx[i]);
                ++i;
            }
            wr[this.npar - 1] = galois.mul(ib, this.encodeGx[this.npar - 1]);
            ++idx;
        }
        if (parity != null) {
            System.arraycopy(wr, 0, parity, parityStartPos, this.npar);
        }
        return 0;
    }

    public int encode(int[] data, int length, int[] parity) {
        return this.encode(data, length, parity, 0);
    }

    public int encode(int[] data, int[] parity) {
        return this.encode(data, data.length, parity, 0);
    }
}

