/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.ZplPrintMode;

public abstract class PrinterStatus {
    public ZplPrintMode printMode;
    public int labelLengthInDots;
    public int numberOfFormatsInReceiveBuffer;
    public int labelsRemainingInBatch;
    public boolean isPartialFormatInProgress;
    public boolean isHeadCold;
    public boolean isHeadOpen;
    public boolean isHeadTooHot;
    public boolean isPaperOut;
    public boolean isRibbonOut;
    public boolean isReceiveBufferFull;
    public boolean isPaused;
    public boolean isReadyToPrint;
    protected Connection printerConnection;
    private boolean statusHasBeenRetrievedFromPrinter = false;

    protected abstract void updateStatus() throws ConnectionException;

    public PrinterStatus(Connection connection) throws ConnectionException {
        this.printerConnection = connection;
        this.numberOfFormatsInReceiveBuffer = 0;
        this.labelsRemainingInBatch = 0;
        this.isPartialFormatInProgress = false;
        this.isHeadCold = false;
        this.printMode = ZplPrintMode.UNKNOWN;
        this.labelLengthInDots = 0;
        this.getStatusFromPrinter();
    }

    private void getStatusFromPrinter() throws ConnectionException {
        if (!this.statusHasBeenRetrievedFromPrinter) {
            this.updateStatus();
            this.statusHasBeenRetrievedFromPrinter = true;
            this.isReadyToPrint = !this.isPaperOut;
            this.isReadyToPrint &= !this.isPaused;
            this.isReadyToPrint &= !this.isReceiveBufferFull;
            this.isReadyToPrint &= !this.isHeadTooHot;
            this.isReadyToPrint &= !this.isHeadOpen;
            this.isReadyToPrint &= !this.isRibbonOut;
        }
    }
}

