/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private final String pathToZipFile;
    private FileInputStream fis = null;
    private ZipInputStream zin = null;
    private BufferedInputStream bis = null;

    public ZipUtil(String string) {
        this.pathToZipFile = string;
    }

    private void openStreams() throws IOException {
        this.closeStreams();
        this.fis = new FileInputStream(this.pathToZipFile);
        this.bis = new BufferedInputStream(this.fis);
        this.zin = new ZipInputStream(this.bis);
    }

    public void closeStreams() throws IOException {
        if (this.zin != null) {
            this.zin.close();
            this.zin = null;
        }
        if (this.bis != null) {
            this.bis.close();
            this.bis = null;
        }
        if (this.fis != null) {
            this.fis.close();
            this.fis = null;
        }
    }

    public List<String> getEntryNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ZipEntry zipEntry;
            this.openStreams();
            while ((zipEntry = this.zin.getNextEntry()) != null) {
                arrayList.add(zipEntry.getName());
            }
            this.closeStreams();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    public boolean containsEntry(String string) {
        boolean bl = false;
        try {
            ZipEntry zipEntry;
            this.openStreams();
            while ((zipEntry = this.zin.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(string)) continue;
                bl = true;
            }
            this.closeStreams();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public void extractEntry(String string, String string2) throws IOException {
        ZipEntry zipEntry;
        this.openStreams();
        while ((zipEntry = this.zin.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(string2)) continue;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            byte[] byArray = new byte[16384];
            int n = -1;
            while ((n = this.zin.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }
        this.closeStreams();
    }

    public byte[] extractEntry(String string) throws FileNotFoundException, IOException {
        byte[] byArray = new byte[]{};
        InputStream inputStream = this.getInputStreamToEntry(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[16384];
        int n = -1;
        while (inputStream != null && (n = inputStream.read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        byArray = byteArrayOutputStream.toByteArray();
        this.closeStreams();
        return byArray;
    }

    public byte[] extractExtraFromEntry(String string) throws FileNotFoundException, IOException {
        ZipEntry zipEntry;
        this.openStreams();
        while ((zipEntry = this.zin.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(string)) continue;
            return zipEntry.getExtra();
        }
        this.closeStreams();
        return null;
    }

    public InputStream getInputStreamToEntry(String string) throws IOException {
        ZipEntry zipEntry;
        this.openStreams();
        while ((zipEntry = this.zin.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(string)) continue;
            return this.zin;
        }
        this.closeStreams();
        return null;
    }

    public String getEntryContents(String string) throws FileNotFoundException, IOException {
        return new String(this.extractEntry(string), "utf8");
    }

    public String getEntryExtraContent(String string) throws FileNotFoundException, IOException {
        byte[] byArray = this.extractExtraFromEntry(string);
        if (byArray == null) {
            return "";
        }
        return new String(byArray, "utf8");
    }

    public void removeEntry(String string) throws IOException {
        if (this.pathToZipFile == null || this.pathToZipFile.isEmpty() || string == null || string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Set<EntryData> set = this.readEntries();
        set.remove(new EntryData(string));
        this.writeEntries(set);
    }

    public void addEntry(String string, byte[] byArray) throws IOException {
        this.addEntry(string, byArray, null);
    }

    public void addEntry(String string, byte[] byArray, byte[] byArray2) throws IOException {
        if (this.pathToZipFile == null || this.pathToZipFile.isEmpty() || string == null || string.isEmpty() || byArray == null) {
            throw new IllegalArgumentException();
        }
        this.removeEntry(string);
        Set<EntryData> set = this.readEntries();
        set.add(new EntryData(string, byArray, byArray2));
        this.writeEntries(set);
    }

    public void addEntry(String string, File file) throws IOException {
        this.addEntry(string, file, null);
    }

    public void addEntry(String string, File file, byte[] byArray) throws IOException {
        if (this.pathToZipFile == null || this.pathToZipFile.isEmpty() || string == null || string.isEmpty() || file == null) {
            throw new IllegalArgumentException();
        }
        this.removeEntry(string);
        Set<EntryData> set = this.readEntries();
        set.add(new EntryData(string, file, byArray));
        this.writeEntries(set);
    }

    private Set<EntryData> readEntries() {
        List<String> list = this.getEntryNames();
        HashSet<EntryData> hashSet = new HashSet<EntryData>();
        for (String string : list) {
            try {
                hashSet.add(new EntryData(string, this.extractEntry(string)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return hashSet;
    }

    private void writeEntries(Set<EntryData> set) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.pathToZipFile);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        for (EntryData entryData : set) {
            ZipEntry zipEntry = new ZipEntry(entryData.name);
            if (entryData.extraData != null) {
                zipEntry.setExtra(entryData.extraData);
            }
            zipOutputStream.putNextEntry(zipEntry);
            if (entryData.srcData != null) {
                zipOutputStream.write(entryData.srcData);
            } else if (entryData.srcFile != null) {
                FileInputStream fileInputStream = new FileInputStream(entryData.srcFile);
                byte[] byArray = new byte[16384];
                while (fileInputStream.available() > 0) {
                    int n = fileInputStream.read(byArray);
                    zipOutputStream.write(byArray, 0, n);
                }
                fileInputStream.close();
            }
            zipOutputStream.closeEntry();
        }
        zipOutputStream.close();
        fileOutputStream.close();
    }

    class EntryData {
        byte[] extraData;
        String name = null;
        File srcFile = null;
        byte[] srcData = null;

        public EntryData(String string) {
            this.name = string;
        }

        public EntryData(String string, byte[] byArray) {
            this.name = string;
            this.srcData = byArray;
        }

        public EntryData(String string, byte[] byArray, byte[] byArray2) {
            this.name = string;
            this.srcData = byArray;
            this.extraData = byArray2;
        }

        public EntryData(String string, File file) {
            this.name = string;
            this.srcFile = file;
        }

        public EntryData(String string, File file, byte[] byArray) {
            this.name = string;
            this.srcFile = file;
            this.extraData = byArray;
        }

        public boolean equals(Object object) {
            EntryData entryData = (EntryData)object;
            return entryData.name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

