/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.FileWrapper;
import com.zebra.sdk.util.internal.PrinterFileDescriptor;
import java.util.ArrayList;
import java.util.List;

public class CisdfFileSender {
    private Connection connection;
    private List<PrinterFileDescriptor> fileDescriptors;

    public CisdfFileSender(Connection connection, List<PrinterFileDescriptor> list) {
        this.connection = connection;
        this.fileDescriptors = list;
    }

    public static void send(Connection connection, PrinterFileDescriptor printerFileDescriptor) throws ConnectionException {
        ArrayList<PrinterFileDescriptor> arrayList = new ArrayList<PrinterFileDescriptor>();
        arrayList.add(printerFileDescriptor);
        CisdfFileSender.send(connection, arrayList);
    }

    public static void send(Connection connection, List<PrinterFileDescriptor> list) throws ConnectionException {
        new CisdfFileSender(connection, list).send();
    }

    private void send() throws ConnectionException {
        if (this.fileDescriptors == null || this.fileDescriptors.isEmpty()) {
            throw new IllegalArgumentException("No files to send");
        }
        for (PrinterFileDescriptor printerFileDescriptor : this.fileDescriptors) {
            this.sendToPrinter(printerFileDescriptor);
        }
    }

    private void sendToPrinter(PrinterFileDescriptor printerFileDescriptor) throws ConnectionException {
        this.connection.write(FileWrapper.createCisdfHeader(printerFileDescriptor).getBytes());
        FileUtilities.sendFileContentsInChunks(this.connection, printerFileDescriptor.getSourceStream());
        this.connection.write(FileWrapper.getCisdfTrailer());
    }
}

