/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import com.zebra.sdk.util.fileConversion.internal.DataFormatSpecifier;
import com.zebra.sdk.util.internal.ZPLUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DYDataProviderStream
extends InputStream {
    InputStream sourceStream;
    String[] headerParts = new String[]{"", "", "", "", ""};
    int[] preReaderDataHeader = new int[5];
    int preReaderDataHeaderIndex = 0;
    private DataFormatSpecifier dataFormatSpecifier = DataFormatSpecifier.OTHER;

    public DYDataProviderStream(InputStream inputStream) throws IOException {
        this.sourceStream = inputStream;
        int n = 0;
        int n2 = 0;
        while (n != 5 && n2 != -1) {
            n2 = this.sourceStream.read();
            if (n2 == 44 || n2 == 31) {
                ++n;
                continue;
            }
            int n3 = n;
            this.headerParts[n3] = this.headerParts[n3] + (char)n2;
        }
        if (n != 5) {
            throw new IOException("Invalid ~DY Header");
        }
        this.headerParts[0] = this.headerParts[0].replace(ZPLUtilities.ZPL_INTERNAL_COMMAND_PREFIX + "DY", "");
        this.headerParts[0] = this.headerParts[0].replace("~DY", "").trim();
        this.checkAndAdjustFileNameAndExtensionCode();
        this.adjustDataFormatSpecifier();
        for (int i = 0; i < this.preReaderDataHeader.length; ++i) {
            this.preReaderDataHeader[i] = inputStream.read();
        }
        this.setDataFormatSpecifier();
        if (this.isDataMimed()) {
            this.ignorePrereadData();
        }
    }

    private void adjustDataFormatSpecifier() {
        List<String> list = Arrays.asList("B", "E", "T", "NRD", "PAC");
        if (list.contains(this.headerParts[2].toUpperCase())) {
            this.headerParts[1] = "B";
        }
    }

    private void checkAndAdjustFileNameAndExtensionCode() {
        String string = "G";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BMP", "B");
        hashMap.put("TTE", "E");
        hashMap.put("GRF", "G");
        hashMap.put("PNG", "P");
        hashMap.put("TTF", "T");
        hashMap.put("PCX", "X");
        hashMap.put("NRD", "NRD");
        hashMap.put("PAC", "PAC");
        List<String> list = Arrays.asList("B", "E", "G", "P", "T", "X", "NRD", "PAC");
        String[] stringArray = this.headerParts[0].split("\\.");
        if (list.contains(this.headerParts[2].toUpperCase())) {
            string = this.headerParts[2].toUpperCase();
        } else if (2 == stringArray.length && 0 < stringArray[1].length() && hashMap.containsKey(stringArray[1].toUpperCase())) {
            string = (String)hashMap.get(stringArray[1].toUpperCase());
        }
        this.headerParts[2] = string;
        for (Map.Entry entry : hashMap.entrySet()) {
            if (!((String)entry.getValue()).equals(string)) continue;
            this.headerParts[0] = stringArray[0] + "." + (String)entry.getKey();
        }
    }

    private boolean isDataMimed() {
        return this.dataFormatSpecifier == DataFormatSpecifier.MIME_COMPRESSED || this.dataFormatSpecifier == DataFormatSpecifier.MIME_UNCOMPRESSED;
    }

    private void ignorePrereadData() {
        this.preReaderDataHeaderIndex = this.preReaderDataHeader.length;
    }

    private void setDataFormatSpecifier() {
        this.dataFormatSpecifier = this.getFormatDownloadedInDataField().equalsIgnoreCase("B") ? DataFormatSpecifier.RAW_BINARY : (this.isMimeUncompressed() ? DataFormatSpecifier.MIME_UNCOMPRESSED : (this.isMimeCompressed() ? DataFormatSpecifier.MIME_COMPRESSED : DataFormatSpecifier.ASCII_HEX));
    }

    private boolean isMimeUncompressed() {
        return new String(this.preReaderDataHeader, 0, this.preReaderDataHeader.length).equalsIgnoreCase(":B64:");
    }

    private boolean isMimeCompressed() {
        return new String(this.preReaderDataHeader, 0, this.preReaderDataHeader.length).equalsIgnoreCase(":Z64:");
    }

    @Override
    public int read() throws IOException {
        int n = -1;
        n = this.preReaderDataHeaderIndex < this.preReaderDataHeader.length ? this.preReaderDataHeader[this.preReaderDataHeaderIndex++] : this.sourceStream.read();
        return n;
    }

    public InputStream getSourceStream() {
        return this.sourceStream;
    }

    public String getFilenameOnPrinter() {
        return this.headerParts[0];
    }

    public String getFormatDownloadedInDataField() {
        return this.headerParts[1];
    }

    public String getFileExtensionCode() {
        return this.headerParts[2];
    }

    public int getTotalBytesInData() throws IOException {
        int n = -1;
        try {
            n = this.headerParts[3].isEmpty() ? -1 : Integer.parseInt(this.headerParts[3]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < 0) {
            throw new IOException("Invalid ~DY Header");
        }
        return n;
    }

    public int getBytesPerRow() throws IOException {
        if (this.headerParts[4].isEmpty()) {
            return -1;
        }
        int n = -1;
        try {
            n = Integer.parseInt(this.headerParts[4]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < 0) {
            throw new IOException("Invalid ~DY Header");
        }
        return n;
    }

    public DataFormatSpecifier getDataFormatSpecifier() {
        return this.dataFormatSpecifier;
    }
}

