/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.device.ProgressMonitor;
import com.zebra.sdk.printer.FirmwareUpdateHandlerBase;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.operations.internal.PrinterOperationBase;
import com.zebra.sdk.util.internal.FileUtilities;
import java.io.InputStream;

public class DownloadFirmwarePrinterOperation
extends PrinterOperationBase<Void> {
    private static final long serialVersionUID = -856246879624951690L;
    private InputStream firmwareInputStream;
    private int fileSize;
    private FirmwareUpdateHandlerBase handler;

    public DownloadFirmwarePrinterOperation(Connection connection, InputStream inputStream, int n, PrinterLanguage printerLanguage, FirmwareUpdateHandlerBase firmwareUpdateHandlerBase) {
        super(connection, printerLanguage);
        this.firmwareInputStream = inputStream;
        this.fileSize = n;
        this.handler = firmwareUpdateHandlerBase;
    }

    @Override
    public Void execute() throws ConnectionException {
        this.selectProperChannel();
        this.isOkToProceed();
        this.updateFirmwareUnconditionallyNoReconnect();
        return null;
    }

    protected void selectProperChannel() {
        if (this.connection instanceof MultichannelConnection) {
            this.connection = ((MultichannelConnection)this.connection).getPrintingChannel();
        }
    }

    private void isOkToProceed() throws ConnectionException {
        if (this.connection instanceof StatusConnection) {
            throw new ConnectionException("Cannot download firmware over status channel");
        }
        if (!this.connection.isConnected()) {
            throw new ConnectionException("The connection is not an open printing channel");
        }
    }

    private void updateFirmwareUnconditionallyNoReconnect() throws ConnectionException {
        ProgressMonitor progressMonitor = new ProgressMonitor(){

            @Override
            public void updateProgress(int n, int n2) {
                DownloadFirmwarePrinterOperation.this.handler.progressUpdate(n, n2);
            }
        };
        FileUtilities.sendFileContentsInChunks(this.connection, progressMonitor, this.firmwareInputStream, this.fileSize);
        this.handler.firmwareDownloadComplete();
        this.connection.close();
    }
}

