/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.ConnectionBuilderInternal;
import com.zebra.sdk.printer.FieldDescriptionData;
import com.zebra.sdk.printer.ZebraPrinter;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.internal.FormatUtilZpl;
import com.zebra.sdk.util.internal.FileReader;

public class TemplateInfo {
    public boolean isLocalToComputer = false;
    public String contents;
    public String pathOnPrinter;
    public FieldDescriptionData[] variableFields;

    public void acquire(String string, String string2) {
        this.readTemplate(string, string2);
        this.pathOnPrinter = FormatUtilZpl.extractDFName(this.contents);
        this.variableFields = this.extractVariableFieldsFromZpl();
    }

    private void readTemplate(String string, String string2) {
        this.isLocalToComputer = true;
        this.contents = FileReader.toString(string2);
        if (this.contents.equals("")) {
            this.getTemplateFromPrinter(string, string2);
        }
        if (this.contents.equals("")) {
            throw new RuntimeException("Template file (" + string2 + ") does not exist or is empty.");
        }
    }

    private void getTemplateFromPrinter(String string, String string2) {
        if (string != null) {
            Connection connection = null;
            try {
                connection = ConnectionBuilderInternal.build(string);
                connection.open();
                ZebraPrinter zebraPrinter = ZebraPrinterFactory.getInstance(connection);
                this.contents = new String(zebraPrinter.retrieveFormatFromPrinter(string2));
                this.isLocalToComputer = false;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getLocalizedMessage());
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (ConnectionException connectionException) {}
            }
        }
    }

    private FieldDescriptionData[] extractVariableFieldsFromZpl() {
        return FormatUtilZpl.getVariableFieldsS(this.contents);
    }
}

