/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.PrinterCommandImpl;
import com.zebra.sdk.printer.PrinterStatus;
import com.zebra.sdk.printer.ZplPrintMode;
import com.zebra.sdk.util.internal.StringUtilities;
import com.zebra.sdk.util.internal.ZPLUtilities;

public class PrinterStatusZpl
extends PrinterStatus {
    public PrinterStatusZpl(Connection connection) throws ConnectionException {
        super(connection);
    }

    @Override
    protected void updateStatus() throws ConnectionException {
        String[] stringArray = this.getPrinterStatus();
        this.labelsRemainingInBatch = Integer.parseInt(stringArray[20]);
        this.numberOfFormatsInReceiveBuffer = Integer.parseInt(stringArray[4]);
        this.isPartialFormatInProgress = stringArray[7].equals("1");
        this.isHeadCold = stringArray[10].equals("1");
        this.isHeadOpen = stringArray[14].equals("1");
        this.isHeadTooHot = stringArray[11].equals("1");
        this.isPaperOut = stringArray[1].equals("1");
        this.isRibbonOut = stringArray[15].equals("1");
        this.isReceiveBufferFull = stringArray[5].equals("1");
        this.isPaused = stringArray[2].equals("1");
        this.labelLengthInDots = Integer.parseInt(stringArray[3]);
        this.printMode = PrinterStatusZpl.getPrintModeFromHs(stringArray[17].charAt(0));
    }

    protected String[] getPrinterStatus() throws ConnectionException {
        byte[] byArray = this.getStatusInfoFromPrinter();
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{};
        if (byArray != null) {
            int n = this.findStartOfHsResponse(byArray);
            if (n == byArray.length) {
                throw new ConnectionException("Malformed status response - unable to determine printer status");
            }
            byte by = this.getLineSeparatorChar();
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == by) {
                    byArray[i] = 44;
                }
                if (byArray[i] <= 31 || byArray[i] >= 127) continue;
                stringBuffer.append(String.valueOf((char)byArray[i]));
            }
        }
        if (stringBuffer.length() >= 1 && (stringArray = StringUtilities.split(stringBuffer.toString(), ",")).length < 25) {
            throw new ConnectionException("Malformed status response - unable to determine printer status");
        }
        return stringArray;
    }

    protected byte getLineSeparatorChar() {
        return 3;
    }

    protected int findStartOfHsResponse(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length && byArray[n] != 2; ++n) {
        }
        return n;
    }

    protected byte[] getStatusInfoFromPrinter() throws ConnectionException {
        PrinterCommandImpl printerCommandImpl = new PrinterCommandImpl(ZPLUtilities.PRINTER_STATUS);
        return printerCommandImpl.sendAndWaitForResponse(this.printerConnection);
    }

    private static ZplPrintMode getPrintModeFromHs(char c) {
        char c2 = String.valueOf(c).toUpperCase().charAt(0);
        switch (c2) {
            case '0': {
                return ZplPrintMode.REWIND;
            }
            case '1': {
                return ZplPrintMode.PEEL_OFF;
            }
            case '2': {
                return ZplPrintMode.TEAR_OFF;
            }
            case '3': {
                return ZplPrintMode.CUTTER;
            }
            case '4': {
                return ZplPrintMode.APPLICATOR;
            }
            case '5': {
                return ZplPrintMode.DELAYED_CUT;
            }
            case '6': {
                return ZplPrintMode.LINERLESS_PEEL;
            }
            case '7': {
                return ZplPrintMode.LINERLESS_REWIND;
            }
            case '8': {
                return ZplPrintMode.PARTIAL_CUTTER;
            }
            case '9': {
                return ZplPrintMode.RFID;
            }
            case 'K': {
                return ZplPrintMode.KIOSK;
            }
        }
        return ZplPrintMode.UNKNOWN;
    }
}

