/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.internal;

import com.zebra.sdk.commandline.internal.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParsedArguments {
    private String command;
    private List<String> args = new ArrayList<String>();
    private Map<String, String> options = new HashMap<String, String>();

    ParsedArguments() {
    }

    public void addArg(String string) {
        this.args.add(string);
    }

    public void addOption(String string, String string2) {
        this.options.put(string, string2);
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String getCommand() {
        return this.command;
    }

    public int getArgSize() {
        return this.args.size();
    }

    public int getOptSize() {
        return this.options.size();
    }

    public String getArg(int n) {
        if (n >= this.args.size() || n < 0) {
            return null;
        }
        return this.args.get(n);
    }

    public boolean containsOption(Option option) {
        String string = option.getName();
        String string2 = option.getLongName();
        if (string == null) {
            return this.options.containsKey(string2);
        }
        if (string2 == null) {
            return this.options.containsKey(string);
        }
        if (this.isArgumentDuplicated(option)) {
            throw new IllegalArgumentException("Argument given twice.");
        }
        return this.options.containsKey(string) || this.options.containsKey(string2);
    }

    private boolean isArgumentDuplicated(Option option) {
        return this.options.containsKey(option.getName()) && this.options.containsKey(option.getLongName());
    }

    public String getOptionArgument(Option option) throws IllegalArgumentException {
        if (this.containsOption(option)) {
            String string = this.options.get(option.getName());
            String string2 = this.options.get(option.getLongName());
            return string != null ? string : string2;
        }
        return null;
    }
}

