/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.settings.internal;

import com.zebra.sdk.settings.Setting;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.settings.internal.SettingsBuilder;
import com.zebra.sdk.settings.internal.ZebraSettingsList;
import com.zebra.sdk.util.internal.ZipUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ZebraSettingsListFromProfile
extends ZebraSettingsList {
    private String pathToProfile;

    public ZebraSettingsListFromProfile(String string) {
        this.pathToProfile = string;
    }

    @Override
    protected byte[] getUpdatedJsonData() throws Exception {
        return new ZipUtil(this.pathToProfile).extractEntry("settings.json");
    }

    @Override
    public Map<String, String> getValues(List<String> list) throws SettingsException {
        List<String> list2 = this.filterOutUnreadableSettings(list);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : list2) {
            Setting setting = this.getSettingById(string);
            linkedHashMap.put(string, setting.getValue());
        }
        return linkedHashMap;
    }

    @Override
    public void setSetting(String string, String string2) throws SettingsException {
        this.updateInternalState(string, string2);
        this.storeSettingValues();
    }

    @Override
    public void setSettings(Map<String, String> map) throws SettingsException {
        for (String string : map.keySet()) {
            try {
                this.updateInternalState(string, map.get(string));
            }
            catch (SettingsException settingsException) {}
        }
        this.storeSettingValues();
    }

    private void storeSettingValues() throws SettingsException {
        SettingsBuilder settingsBuilder = new SettingsBuilder(this.getAllSettings());
        try {
            String string = settingsBuilder.toAllconfigJson();
            new ZipUtil(this.pathToProfile).addEntry("settings.json", string.getBytes());
        }
        catch (IOException iOException) {
            throw new SettingsException(iOException.getMessage());
        }
    }

    @Override
    public void setSetting(String string, Setting setting) throws SettingsException {
        Map<String, Setting> map = this.getAllSettings();
        map.remove(string);
        map.put(string, setting);
        this.storeSettingValues();
    }

    @Override
    public void setAllSettings(Map<String, Setting> map) throws SettingsException {
        Map<String, Setting> map2 = this.getAllSettings();
        for (String string : map.keySet()) {
            map2.remove(string);
            map2.put(string, map.get(string));
        }
        this.storeSettingValues();
    }

    @Override
    public Map<String, String> processSettingsViaMap(Map<String, String> map) throws SettingsException {
        this.setSettings(map);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(map.keySet());
        return this.getValues(arrayList);
    }
}

