/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.remote.discovery;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.remote.comm.internal.WebSocketPortalI;
import com.zebra.sdk.remote.discovery.ConnectionHandlerI;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

public class RemoteDiscoverer {
    private RemoteDiscoverer() {
    }

    public static List<DiscoveredPrinter> getConnectedPrinters() throws ConnectionException {
        return RemoteDiscoverer.getConnectedPrinters(11995);
    }

    public static List<DiscoveredPrinter> getConnectedPrinters(int n) throws ConnectionException {
        try {
            CopyOnWriteArraySet<DiscoveredPrinter> copyOnWriteArraySet = RemoteDiscoverer.getRmiHandle(n).getConnectedPrinters();
            return Arrays.asList(copyOnWriteArraySet.toArray(new DiscoveredPrinter[0]));
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException("Unable to retrieve connected printer list.  ERROR: " + remoteException.getMessage());
        }
    }

    public static void registerForConnections(ConnectionHandlerI connectionHandlerI, int n) throws ConnectionException {
        try {
            RemoteDiscoverer.getRmiHandle(n).registerConnectionHandler(connectionHandlerI);
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException("Unable to register connection handler.  ERROR: " + remoteException.getMessage());
        }
    }

    private static WebSocketPortalI getRmiHandle(int n) throws ConnectionException {
        try {
            Registry registry = LocateRegistry.getRegistry(n);
            return (WebSocketPortalI)registry.lookup("WebSocketPortal");
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException("Unable to connect with Zebra Weblink Servlet.  ERROR: " + remoteException.getMessage());
        }
        catch (NotBoundException notBoundException) {
            throw new ConnectionException("Failed to connect with WebSocketPortal, not found.");
        }
    }
}

