/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.ConnectionBuilderInternal;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.graphics.ZebraImageI;
import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import com.zebra.sdk.printer.FileDeletionOption;
import com.zebra.sdk.printer.FirmwareUpdateHandler;
import com.zebra.sdk.printer.NotALinkOsPrinterException;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.PrinterStatus;
import com.zebra.sdk.printer.PrinterStatusMessages;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.TcpPortStatus;
import com.zebra.sdk.printer.ZebraPrinter;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.internal.GraphicsConversionUtilCpcl;
import com.zebra.sdk.printer.internal.GraphicsConversionUtilZpl;
import com.zebra.sdk.printer.internal.GraphicsConvertionUtil;
import com.zebra.sdk.printer.operations.internal.HostStatusOperation;
import com.zebra.sdk.settings.Setting;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.settings.internal.ConnectionUtil;
import com.zebra.sdk.util.internal.ZPLUtilities;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class PrinterUtil {
    private PrinterUtil() {
    }

    public static void sendContents(String string, String string2) throws ConnectionException, IOException {
        PrinterUtil.sendContents(string, string2, "UTF8");
    }

    public static void sendContents(String string, String string2, String string3) throws ConnectionException, IOException {
        PrinterUtil.sendContents(string, new ByteArrayInputStream(string2.getBytes(string3)));
    }

    public static void sendContents(String string, InputStream inputStream) throws ConnectionException, IOException {
        PrinterUtil.sendContents(string, inputStream, "UTF8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendContents(String string, InputStream inputStream, String string2) throws ConnectionException, IOException {
        Connection connection = null;
        try {
            connection = ConnectionBuilderInternal.build(string);
            connection.open();
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            connection.write(byArray);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendJSON(String string, InputStream inputStream, String string2) throws ConnectionException, IOException {
        Connection connection = null;
        try {
            connection = ConnectionBuilderInternal.build(string);
            connection.open();
            connection = ConnectionUtil.selectConnection(connection);
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            connection.write(byArray);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TcpPortStatus> getPortStatus(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        List<TcpPortStatus> list = null;
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            list = zebraPrinterLinkOs.getPortStatus();
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getOdometerStatus(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            Connection connection = zebraPrinterLinkOs.getConnection();
            arrayList.add("Total Print Length: " + SGD.GET("odometer.total_print_length", connection));
            arrayList.add("Head Clean Count: " + SGD.GET("odometer.headclean", connection));
            arrayList.add("Label Dot Length: " + SGD.GET("odometer.label_dot_length", connection));
            arrayList.add("Head New: " + SGD.GET("odometer.headnew", connection));
            arrayList.add("Latch Open Count: " + SGD.GET("odometer.latch_open_count", connection));
            arrayList.add("User Resettable Counter: " + SGD.GET("odometer.media_marker_count", connection));
            arrayList.add("User Resettable Counter 1: " + SGD.GET("odometer.media_marker_count1", connection));
            arrayList.add("User Resettable Counter 2: " + SGD.GET("odometer.media_marker_count2", connection));
            arrayList.add("User Label Resettable Counter: " + SGD.GET("odometer.user_label_count", connection));
            arrayList.add("User Label Resettable Counter 1: " + SGD.GET("odometer.user_label_count1", connection));
            arrayList.add("User Label Resettable Counter 2: " + SGD.GET("odometer.user_label_count2", connection));
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPrinterStatus(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            PrinterStatus printerStatus = zebraPrinterLinkOs.getCurrentStatus();
            PrinterStatusMessages printerStatusMessages = new PrinterStatusMessages(printerStatus);
            String[] stringArray = printerStatusMessages.getStatusMessage();
            if (printerStatus.isReadyToPrint) {
                arrayList.add("Ready To Print");
            } else {
                for (String string2 : stringArray) {
                    arrayList.add(string2);
                }
            }
            arrayList.add("Partial format is in progress: " + Boolean.toString(printerStatus.isPartialFormatInProgress));
            arrayList.add("Labels remaining in queue: " + printerStatus.numberOfFormatsInReceiveBuffer);
            arrayList.add("Printing " + printerStatus.labelsRemainingInBatch + " labels remaining in current batch");
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String quickStatus(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        String string2 = "";
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            PrinterStatus printerStatus = zebraPrinterLinkOs.getCurrentStatus();
            PrinterStatusMessages printerStatusMessages = new PrinterStatusMessages(printerStatus);
            String[] stringArray = printerStatusMessages.getStatusMessage();
            string2 = printerStatus.isReadyToPrint ? "Ready To Print" : stringArray[0];
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClock(String string, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.setClock(string2);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] deleteFileReportDeleted(String string, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, NotALinkOsPrinterException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            String[] stringArray;
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            arrayList.addAll(Arrays.asList(zebraPrinterLinkOs.retrieveFileNames()));
            zebraPrinterLinkOs.deleteFile(string2);
            for (String string3 : stringArray = zebraPrinterLinkOs.retrieveFileNames()) {
                arrayList.remove(string3);
            }
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String string, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.deleteFile(string2);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listFiles(String string, String string2) throws ConnectionException, ZebraIllegalArgumentException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        String[] stringArray = null;
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            String[] stringArray2 = zebraPrinterLinkOs.retrieveFileNames();
            stringArray = ZPLUtilities.filterFileList(stringArray2, string2);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getObjectFromPrinter(String string, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException, ZebraIllegalArgumentException {
        byte[] byArray = null;
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            byArray = zebraPrinterLinkOs.getObjectFromPrinter(string2);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getObjectFromPrinter(OutputStream outputStream, String string, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException, ZebraIllegalArgumentException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.getObjectFromPrinter(outputStream, string2);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getObjectFromPrinterViaFtp(String string, String string2, String string3) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException, ZebraIllegalArgumentException {
        byte[] byArray = null;
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            byArray = zebraPrinterLinkOs.getObjectFromPrinterViaFtp(string2, string3);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getObjectFromPrinterViaFtp(OutputStream outputStream, String string, String string2, String string3) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException, ZebraIllegalArgumentException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.getObjectFromPrinterViaFtp(outputStream, string2, string3);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateFirmware(String string, String string2, long l) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, DiscoveryException, TimeoutException, FileNotFoundException {
        Connection connection = ConnectionBuilderInternal.build(string);
        try {
            connection.open();
            ZebraPrinter zebraPrinter = ZebraPrinterFactory.getInstance(connection);
            ZebraPrinterLinkOs zebraPrinterLinkOs = ZebraPrinterFactory.createLinkOsPrinter(zebraPrinter);
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.updateFirmware(string2, l, new FirmwareUpdateHandler(){

                    @Override
                    public void firmwareDownloadComplete() {
                    }

                    @Override
                    public void progressUpdate(int n, int n2) {
                    }

                    @Override
                    public void printerOnline(ZebraPrinterLinkOs zebraPrinterLinkOs, String string) {
                    }
                });
            }
        }
        finally {
            connection.close();
        }
    }

    private static PrinterLanguage getPrinterLanguageFromFileExtension(String string) throws ZebraIllegalArgumentException {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            String string2 = string.substring(n + 1).trim().toUpperCase();
            if (string2.equals("GRF") || string2.equals("PNG")) {
                return PrinterLanguage.ZPL;
            }
            if (string2.equals("PCX")) {
                return PrinterLanguage.CPCL;
            }
        }
        throw new ZebraIllegalArgumentException("Unsupported file type for graphics conversion");
    }

    public static void convertGraphic(String string, ZebraImageI zebraImageI, OutputStream outputStream) throws ZebraIllegalArgumentException, IOException {
        PrinterUtil.convertGraphic(string, zebraImageI, 0, 0, outputStream);
    }

    public static void convertGraphic(String string, ZebraImageI zebraImageI, int n, int n2, OutputStream outputStream) throws ZebraIllegalArgumentException, IOException {
        if (string == null || zebraImageI == null || outputStream == null) {
            throw new ZebraIllegalArgumentException("Parameter cannot be null");
        }
        PrinterLanguage printerLanguage = PrinterUtil.getPrinterLanguageFromFileExtension(string);
        GraphicsConvertionUtil graphicsConvertionUtil = printerLanguage == PrinterLanguage.CPCL ? new GraphicsConversionUtilCpcl() : new GraphicsConversionUtilZpl();
        graphicsConvertionUtil.sendImageToStream(string, (ZebraImageInternal)zebraImageI, n, n2, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createProfile(String string, String string2) throws IOException, ZebraIllegalArgumentException, ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.createProfile(string2);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBackup(String string, String string2) throws ConnectionException, IOException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.createBackup(string2);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    public static void loadProfile(String string, String string2, FileDeletionOption fileDeletionOption) throws ConnectionException, IOException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        PrinterUtil.loadProfile(string, string2, fileDeletionOption, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProfile(String string, String string2, FileDeletionOption fileDeletionOption, boolean bl) throws ConnectionException, IOException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.loadProfile(string2, fileDeletionOption, bl);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    public static void loadBackup(String string, String string2) throws ConnectionException, IOException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        PrinterUtil.loadBackup(string, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadBackup(String string, String string2, boolean bl) throws ConnectionException, IOException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.loadBackup(string2, bl);
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeFile(String string, String string2, String string3) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException, ZebraIllegalArgumentException, IOException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            if (string3 != null) {
                zebraPrinterLinkOs.storeFileOnPrinter(string2, string3);
            } else {
                zebraPrinterLinkOs.storeFileOnPrinter(string2);
            }
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPrinter(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.reset();
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetNetwork(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.resetNetwork();
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restorePrinterDefaults(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.restoreDefaults();
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreNetworkDefaults(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.restoreNetworkDefaults();
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printConfigLabel(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.printConfigurationLabel();
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printNetworkConfigLabel(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.printNetworkConfigurationLabel();
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDirectoryLabel(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            zebraPrinterLinkOs.printDirectoryLabel();
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
    }

    private static ZebraPrinterLinkOs getLinkOsPrinter(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        Connection connection = null;
        connection = ConnectionBuilderInternal.build(string);
        connection.open();
        ZebraPrinter zebraPrinter = ZebraPrinterFactory.getInstance(connection);
        ZebraPrinterLinkOs zebraPrinterLinkOs = ZebraPrinterFactory.createLinkOsPrinter(zebraPrinter);
        if (zebraPrinterLinkOs == null) {
            connection.close();
            throw new NotALinkOsPrinterException();
        }
        return zebraPrinterLinkOs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Setting> getSettingsFromPrinter(String string) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException, SettingsException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        Map<String, Setting> map = null;
        try {
            zebraPrinterLinkOs = PrinterUtil.getLinkOsPrinter(string);
            map = zebraPrinterLinkOs.getAllSettings();
        }
        finally {
            if (zebraPrinterLinkOs != null) {
                zebraPrinterLinkOs.getConnection().close();
            }
        }
        return map;
    }

    public static PrinterStatus getCurrentStatus(Connection connection, PrinterLanguage printerLanguage) throws ConnectionException {
        PrinterStatus printerStatus = new HostStatusOperation(connection, printerLanguage).execute();
        return printerStatus;
    }
}

