/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.discovery.internal.BroadcastA;
import com.zebra.sdk.printer.discovery.internal.ZebraDiscoSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DirectedBroadcast
extends BroadcastA {
    public DirectedBroadcast(String string) throws DiscoveryException {
        this(string, 6000);
    }

    public DirectedBroadcast(String string, int n) throws DiscoveryException {
        super(n);
        try {
            this.broadcastIpAddresses = InetAddress.getAllByName(DirectedBroadcast.getDirectedBroadcastAddress(string));
        }
        catch (UnknownHostException unknownHostException) {
            throw new DiscoveryException("Malformed directed broadcast address");
        }
    }

    public String toString() {
        return this.broadcastIpAddresses[0].toString().substring(1);
    }

    private static String getDirectedBroadcastAddress(String string) throws DiscoveryException {
        if (string == null) {
            throw new DiscoveryException("Malformed directed broadcast address");
        }
        Pattern pattern = Pattern.compile("^((\\d|[1-9]\\d|1\\d\\d|2([0-4]\\d|5[0-5]))\\.(\\d|[1-9]\\d|1\\d\\d|2([0-4]\\d|5[0-5]))\\.(\\d|[1-9]\\d|1\\d\\d|2([0-4]\\d|5[0-5])))(\\.?|\\.(\\d|[1-9]\\d|1\\d\\d|2([0-4]\\d|5[0-5])))?$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find() && matcher.groupCount() > 1) {
            String string2 = matcher.group(1) + ".255";
            return string2;
        }
        throw new DiscoveryException("Malformed directed broadcast address");
    }

    @Override
    protected void setSocketOptions(ZebraDiscoSocket zebraDiscoSocket) throws DiscoveryException {
    }
}

