/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.graphics.internal;

import com.zebra.sdk.graphics.internal.DitheredImageProvider;
import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import com.zebra.sdk.util.internal.Base64;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ZebraImage
implements ZebraImageInternal {
    private BufferedImage image;

    public ZebraImage(BufferedImage bufferedImage) {
        if (null == bufferedImage) {
            throw new IllegalArgumentException("image arg cannot be null");
        }
        this.image = bufferedImage;
    }

    public ZebraImage(String string) throws IOException {
        if (null == string) {
            throw new IllegalArgumentException("image path arg cannot be null");
        }
        this.image = ImageIO.read(new File(string));
        if (null == this.image) {
            throw new IOException("unknown image type");
        }
    }

    public ZebraImage(InputStream inputStream) throws IOException {
        this.image = ImageIO.read(inputStream);
        if (null == this.image) {
            throw new IOException("unknown image type");
        }
    }

    @Override
    public int[] getRow(int n) {
        if (n >= this.getHeight()) {
            return null;
        }
        int[] nArray = new int[this.getWidth()];
        this.image.getRGB(0, n, this.getWidth(), 1, nArray, 0, this.getWidth());
        return nArray;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public boolean scaleImage(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return false;
        }
        int n3 = 0 == this.image.getType() ? 3 : this.image.getType();
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(this.image, 0, 0, n, n2, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        graphics2D.dispose();
        this.image = bufferedImage;
        return true;
    }

    @Override
    public byte[] getDitheredB64EncodedPng() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeDitheredPng(byteArrayOutputStream);
        return Base64.encodeBytes(byteArrayOutputStream.toByteArray(), 8).getBytes();
    }

    @Override
    public void writeDitheredPng(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DitheredImageProvider.getDitheredImage(this, byteArrayOutputStream);
        int n = this.getWidth() / 8 + (this.getWidth() % 8 == 0 ? 0 : 1);
        BufferedImage bufferedImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 12);
        this.removePixelPaddingFromRaster(this.getWidth(), this.getHeight(), byteArrayOutputStream, bufferedImage, n);
        ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
    }

    private void removePixelPaddingFromRaster(int n, int n2, ByteArrayOutputStream byteArrayOutputStream, BufferedImage bufferedImage, int n3) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte by = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                by = byArray[i * n3 + j / 8];
                by = (byte)((by & 1 << 7 - j % 8) != 0 ? 1 : 0);
                writableRaster.setSample(j, i, 0, by);
            }
        }
    }
}

