/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.device.internal;

import com.zebra.sdk.device.internal.ProfileComponentHandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ProfileDisassembler {
    public void disassemble(InputStream inputStream, ProfileComponentHandler profileComponentHandler) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (string.equals("settings.json")) {
                profileComponentHandler.settingsHandler(zipInputStream);
                continue;
            }
            if (string.equals("alerts.json")) {
                profileComponentHandler.alertsHandler(zipInputStream);
                continue;
            }
            if (string.equals("profileSupplement.txt")) {
                profileComponentHandler.supplementHandler(zipInputStream);
                continue;
            }
            if (string.equals("firmwareFile.txt")) {
                profileComponentHandler.firmwareHandler(zipInputStream);
                continue;
            }
            if (string.equals("firmwareFileUserSpecifiedName.txt")) {
                profileComponentHandler.firmwareDisplayNameHandler(zipInputStream);
                continue;
            }
            profileComponentHandler.fileHandler(string, zipInputStream);
        }
        zipInputStream.close();
        bufferedInputStream.close();
    }
}

