/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.operations.internal.PrinterOperationBase;
import com.zebra.sdk.settings.Setting;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.settings.internal.ZebraSettingsListFromConnection;
import java.util.Map;

public class SettingsGrabberOperation
extends PrinterOperationBase<Map<String, Setting>> {
    private static final long serialVersionUID = 561030993363812422L;

    public SettingsGrabberOperation(Connection connection, PrinterLanguage printerLanguage) {
        super(connection, printerLanguage);
    }

    @Override
    public Map<String, Setting> execute() throws ConnectionException {
        this.selectStatusChannelIfOpen();
        this.isOkToProceed();
        ZebraSettingsListFromConnection zebraSettingsListFromConnection = new ZebraSettingsListFromConnection(this.connection);
        try {
            Map<String, Setting> map = zebraSettingsListFromConnection.getAllSettings();
            if (map == null || map.isEmpty()) {
                throw new SettingsException("Error Retrieving Settings or No Printer Connection");
            }
            return map;
        }
        catch (SettingsException settingsException) {
            throw new ConnectionException(settingsException.getLocalizedMessage());
        }
    }

    private void isOkToProceed() throws ConnectionException {
        if (this.isPrintingChannelInLineMode()) {
            throw new ConnectionException("Cannot retrieve settings from printer over printing channel when in line mode");
        }
    }
}

