/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToCsvConverter
extends DefaultHandler {
    private StringBuilder nodeValue;
    Map<String, String> nameValuePairs;
    private String workingVariable;
    ByteArrayOutputStream allLabelsAsCsv = new ByteArrayOutputStream();
    List<String> columns = new ArrayList<String>();
    List<Map<String, String>> labels = new ArrayList<Map<String, String>>();
    private String defaultQuantity = null;

    public static byte[] convert(byte[] byArray) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XmlToCsvConverter xmlToCsvConverter = new XmlToCsvConverter();
            sAXParser.parse((InputStream)new ByteArrayInputStream(byArray), (DefaultHandler)xmlToCsvConverter);
            return xmlToCsvConverter.getCsvOutput();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static InputStream convert(InputStream inputStream) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (inputStream.available() > 0) {
            byArray = new byte[1024];
            int n = inputStream.read(byArray);
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byArray = XmlToCsvConverter.convert(byteArrayOutputStream.toByteArray());
        return new ByteArrayInputStream(byArray);
    }

    private byte[] getCsvOutput() {
        return this.allLabelsAsCsv.toByteArray();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        this.nodeValue.append(cArray, n, n2);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.nodeValue = new StringBuilder();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        super.startElement(string, string2, string3, attributes);
        if (string3.equalsIgnoreCase("label")) {
            this.nameValuePairs = new HashMap<String, String>();
            if (this.defaultQuantity != null) {
                this.nameValuePairs.put("QUANTITY", this.defaultQuantity);
            }
        } else if (string3.equalsIgnoreCase("variable")) {
            this.workingVariable = attributes.getValue(attributes.getIndex("name"));
            if (!this.columns.contains(this.workingVariable)) {
                this.columns.add(this.workingVariable);
            }
        } else if (string3.equalsIgnoreCase("file") && (string4 = attributes.getValue(attributes.getIndex("_QUANTITY"))) != null) {
            this.defaultQuantity = string4;
            this.columns.add("QUANTITY");
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        if (this.nameValuePairs != null) {
            if (string3.equalsIgnoreCase("variable")) {
                this.nameValuePairs.put(this.workingVariable, this.nodeValue.toString().trim());
            } else if (string3.equalsIgnoreCase("label")) {
                this.labels.add(this.nameValuePairs);
            }
            this.nodeValue.setLength(0);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        try {
            for (int i = 0; i < this.columns.size(); ++i) {
                if (i != 0) {
                    this.allLabelsAsCsv.write(",".getBytes());
                }
                this.allLabelsAsCsv.write(this.columns.get(i).getBytes());
            }
            this.allLabelsAsCsv.write("\n".getBytes());
            for (Map<String, String> map : this.labels) {
                for (int i = 0; i < this.columns.size(); ++i) {
                    String string;
                    String string2;
                    if (i != 0) {
                        this.allLabelsAsCsv.write(",".getBytes());
                    }
                    String string3 = string2 = map.get(string = this.columns.get(i)) == null ? "" : map.get(string);
                    if (string2.contains(",")) {
                        string2 = "\"" + string2 + "\"";
                    }
                    this.allLabelsAsCsv.write(string2.getBytes("utf8"));
                }
                this.allLabelsAsCsv.write("\n".getBytes());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

