/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.util.internal.Range;

public class CreateBackupCommand
extends Command {
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int BACKUP_FILE_INDEX = 1;

    public CreateBackupCommand() {
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "backup";
    }

    @Override
    public String getDescription() {
        return "Creates a backup of the printer and stores it to the local file";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getArg(0);
        String string2 = parsedArguments.getArg(1);
        this.verboseFormatPrint("Creating backup of %s%n", string);
        PrinterUtil.createBackup(this.getConnectionFromArgs(parsedArguments, string), string2);
        this.verboseFormatPrint("Saved to file %s%n", string2);
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <filePath> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Create backup of a printer and save to a local file\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 profile.zprofile%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Create a backup and save it to a local file. Connect via port 6101 and use verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:6101 profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Create a backup and save it to a local file via ZDesigner Driver\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("Create a backup and save it to a local file via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" profile.zprofile%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

