/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.operations.internal.PrinterOperation;

public abstract class PrinterOperationBase<T>
implements PrinterOperation<T> {
    protected Connection connection;
    protected PrinterLanguage printerLanguage;

    public PrinterOperationBase(Connection connection, PrinterLanguage printerLanguage) {
        this.connection = connection;
        this.printerLanguage = printerLanguage;
    }

    protected boolean isPrintingChannelInLineMode() {
        return !(this.connection instanceof StatusConnection) && this.printerLanguage == PrinterLanguage.LINE_PRINT;
    }

    protected void selectStatusChannelIfOpen() {
        if (this.connection instanceof MultichannelConnection) {
            MultichannelConnection multichannelConnection = (MultichannelConnection)this.connection;
            this.connection = multichannelConnection.getStatusChannel().isConnected() ? multichannelConnection.getStatusChannel() : multichannelConnection.getPrintingChannel();
        }
    }
}

