/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.PrinterStatus;
import com.zebra.sdk.printer.internal.PrinterStatusZpl;
import com.zebra.sdk.settings.internal.JsonValidator;
import com.zebra.sdk.settings.internal.PrinterlessConnection;
import com.zebra.sdk.util.internal.StringUtilities;
import java.io.IOException;
import java.util.Map;

public class PrinterStatusLinkOs
extends PrinterStatusZpl {
    public PrinterStatusLinkOs(Connection connection) throws ConnectionException {
        super(connection);
    }

    @Override
    protected byte getLineSeparatorChar() {
        return 10;
    }

    @Override
    protected int findStartOfHsResponse(byte[] byArray) {
        return 0;
    }

    @Override
    protected byte[] getStatusInfoFromPrinter() throws ConnectionException {
        byte[] byArray = this.printerConnection.sendAndWaitForValidResponse("{}{\"device.host_status\":null}".getBytes(), this.printerConnection.getMaxTimeoutForRead(), this.printerConnection.getTimeToWaitForMoreData(), new JsonValidator());
        if (byArray.length > 0) {
            return this.parseJsonStatusResponse(new String(byArray));
        }
        throw new ConnectionException("Malformed status response - unable to determine printer status");
    }

    private byte[] parseJsonStatusResponse(String string) throws ConnectionException {
        try {
            Map<String, String> map = StringUtilities.convertKeyValueJsonToMap(string);
            String string2 = map.get("device.host_status");
            String string3 = string2.replaceAll("\\\\r\\\\n", "\n");
            return string3.getBytes();
        }
        catch (IOException iOException) {
            throw new ConnectionException("Malformed status response - unable to determine printer status");
        }
    }

    public static PrinterStatus create(String string) throws ConnectionException {
        String string2 = String.format("{\"device.host_status\":\"%s\"}", string);
        PrinterlessConnection printerlessConnection = new PrinterlessConnection(string2.getBytes());
        return new PrinterStatusLinkOs(printerlessConnection);
    }
}

