/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.settings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.zebra.sdk.settings.internal.SettingRange;
import com.zebra.sdk.settings.internal.SettingRangeChoices;
import com.zebra.sdk.settings.internal.SettingRangeFloat;
import com.zebra.sdk.settings.internal.SettingRangeInteger;
import com.zebra.sdk.settings.internal.SettingRangeIpV4Address;
import com.zebra.sdk.settings.internal.SettingRangeString;
import com.zebra.sdk.settings.internal.SettingType;
import java.io.Serializable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Setting
implements Serializable {
    private static final long serialVersionUID = -7840487209755339898L;
    private String value;
    private String type;
    private String range;
    private boolean clone;
    private boolean archive;
    private String access;

    public String getRange() {
        return this.range;
    }

    public void setRange(String string) {
        this.range = string;
    }

    @JsonIgnore
    public boolean isValid(String string) {
        SettingRange settingRange = null;
        SettingType settingType = SettingType.fromString(this.type);
        if (settingType != null) {
            switch (settingType) {
                case DOUBLE: {
                    settingRange = new SettingRangeFloat(this.range);
                    break;
                }
                case INTEGER: {
                    settingRange = new SettingRangeInteger(this.range);
                    break;
                }
                case ENUM: 
                case BOOL: {
                    settingRange = new SettingRangeChoices(this.range);
                    break;
                }
                case STRING: {
                    settingRange = new SettingRangeString(this.range);
                    break;
                }
                case IPV4ADDRESS: {
                    settingRange = new SettingRangeIpV4Address(this.range);
                    break;
                }
            }
        }
        return settingRange == null || settingRange.isInRange(string);
    }

    public boolean getClone() {
        return this.clone;
    }

    public void setClone(boolean bl) {
        this.clone = bl;
    }

    public boolean getArchive() {
        return this.archive;
    }

    public void setArchive(boolean bl) {
        this.archive = bl;
    }

    public String getAccess() {
        return this.access;
    }

    public void setAccess(String string) {
        this.access = string;
    }

    public String getType() {
        SettingType settingType = SettingType.fromString(this.type);
        return settingType == null ? this.type : settingType.toString();
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    @JsonIgnore
    public boolean isReadOnly() {
        return false == this.access.contains("W");
    }

    @JsonIgnore
    public boolean isWriteOnly() {
        return false == this.access.contains("R");
    }

    public String toString() {
        return "Setting [settingData=value= " + this.value + " type= " + this.type + " range= " + this.range + "]";
    }
}

