/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.comm.internal.PrinterCommandImpl;
import com.zebra.sdk.printer.FieldDescriptionData;
import com.zebra.sdk.printer.internal.CommandType;
import com.zebra.sdk.printer.internal.FormatUtilA;
import com.zebra.sdk.printer.internal.IndexAndCommandType;
import com.zebra.sdk.printer.internal.MalformedFormatException;
import com.zebra.sdk.util.internal.StringUtilities;
import com.zebra.sdk.util.internal.ZPLUtilities;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FormatUtilZpl
extends FormatUtilA {
    public FormatUtilZpl(Connection connection) {
        super(connection);
    }

    @Override
    public byte[] retrieveFormatFromPrinter(String string) throws ConnectionException {
        if (string == null || string.equals("")) {
            return null;
        }
        PrinterCommandImpl printerCommandImpl = new PrinterCommandImpl(ZPLUtilities.decorateWithFormatPrefix("^XA^HF" + string + "^XZ"));
        return printerCommandImpl.sendAndWaitForResponse(this.printerConnection);
    }

    @Override
    public void retrieveFormatFromPrinter(OutputStream outputStream, String string) throws ConnectionException {
        if (string == null || string.equals("")) {
            return;
        }
        PrinterCommandImpl printerCommandImpl = new PrinterCommandImpl(ZPLUtilities.decorateWithFormatPrefix("^XA^HF" + string + "^XZ"));
        printerCommandImpl.sendAndWaitForResponse(outputStream, this.printerConnection);
    }

    @Override
    public void printStoredFormat(String string, Map<Integer, String> map) throws ConnectionException {
        try {
            this.printStoredFormat(string, map, System.getProperty("file.encoding"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    @Override
    public void printStoredFormat(String string, Map<Integer, String> map, String string2) throws ConnectionException, UnsupportedEncodingException {
        this.throwExceptionStatusOnly();
        this.printerConnection.write(FormatUtilZpl.generateStoredFormat(string, map).getBytes(string2));
    }

    public static String generateStoredFormat(String string, Map<Integer, String> map, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("^XA\r\n");
        stringBuffer.append("^XF");
        stringBuffer.append(string);
        stringBuffer.append("^FS\r\n");
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            stringBuffer.append("^FN");
            stringBuffer.append(entry.getKey());
            stringBuffer.append("^FD");
            stringBuffer.append(entry.getValue());
            stringBuffer.append("^FS\r\n");
        }
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append("^PQ" + string2 + "\r\n");
        }
        stringBuffer.append("^XZ");
        return ZPLUtilities.decorateWithFormatPrefix(stringBuffer.toString());
    }

    public static String generateStoredFormat(String string, Map<Integer, String> map) {
        return FormatUtilZpl.generateStoredFormat(string, map, null);
    }

    @Override
    public FieldDescriptionData[] getVariableFields(String string) {
        return FormatUtilZpl.getVariableFieldsS(string);
    }

    public static FieldDescriptionData[] getVariableFieldsS(String string) {
        ArrayList<FieldDescriptionData> arrayList = new ArrayList<FieldDescriptionData>();
        String string2 = "^";
        String string3 = ",";
        int n = 0;
        while (n > -1) {
            int n2;
            block17: {
                boolean bl;
                int n3;
                Object object;
                int n4;
                IndexAndCommandType indexAndCommandType = FormatUtilZpl.findNextCommand(string2, n, string, CommandType.fnCommand);
                n = indexAndCommandType.getIndex();
                CommandType commandType = indexAndCommandType.getCommand();
                boolean bl2 = n > -1;
                if (!bl2) continue;
                n2 = n + 3;
                if (commandType == CommandType.ccCommand) {
                    string2 = string.substring(n2, n2 + 1);
                } else if (commandType == CommandType.fnCommand) {
                    n4 = StringUtilities.indexOf(string, new String[]{string2, ZPLUtilities.ZPL_INTERNAL_FORMAT_PREFIX}, n2);
                    if (n4 > -1) {
                        String string4 = string.substring(n2, n4);
                        try {
                            object = FormatUtilZpl.parseFnCommand(string4);
                            int n5 = FormatUtilZpl.findOccurance(arrayList, (FieldDescriptionData)object);
                            int n6 = n3 = n5 != -1 ? 1 : 0;
                            if (n3 == 1) {
                                boolean bl3 = bl = ((FieldDescriptionData)object).fieldName != null;
                                if (bl) {
                                    arrayList.remove(n5);
                                    arrayList.add((FieldDescriptionData)object);
                                }
                                break block17;
                            }
                            arrayList.add((FieldDescriptionData)object);
                        }
                        catch (MalformedFormatException malformedFormatException) {}
                    }
                } else if (commandType == CommandType.xgCommand) {
                    n2 += 3;
                    n4 = n + 6;
                    int n7 = StringUtilities.indexOf(string, new String[]{string3, ZPLUtilities.ZPL_INTERNAL_DELIMITER}, n4);
                    if (n7 > -1) {
                        object = string.substring(n4, n7);
                        try {
                            FieldDescriptionData fieldDescriptionData = FormatUtilZpl.parseFnCommand((String)object);
                            n3 = FormatUtilZpl.findOccurance(arrayList, fieldDescriptionData);
                            boolean bl4 = bl = n3 != -1;
                            if (bl) {
                                boolean bl5;
                                boolean bl6 = bl5 = fieldDescriptionData.fieldName != null;
                                if (bl5) {
                                    arrayList.remove(n3);
                                    arrayList.add(fieldDescriptionData);
                                }
                            } else {
                                arrayList.add(fieldDescriptionData);
                            }
                        }
                        catch (MalformedFormatException malformedFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            n = n2;
        }
        return arrayList.toArray(new FieldDescriptionData[0]);
    }

    public static String extractDFName(String string) {
        String string2 = "^";
        int n = 0;
        while (n > -1) {
            int n2;
            IndexAndCommandType indexAndCommandType = FormatUtilZpl.findNextCommand(string2, n, string, CommandType.dfCommand);
            n = indexAndCommandType.getIndex();
            CommandType commandType = indexAndCommandType.getCommand();
            boolean bl = n > -1;
            if (!bl) continue;
            int n3 = n + 3;
            if (commandType == CommandType.ccCommand) {
                string2 = string.substring(n3, n3 + 1);
            } else if (commandType == CommandType.dfCommand && (n2 = StringUtilities.indexOf(string, new String[]{string2, ZPLUtilities.ZPL_INTERNAL_FORMAT_PREFIX}, n3)) > -1) {
                return string.substring(n3, n2);
            }
            n = n3;
        }
        return null;
    }

    private static int findOccurance(List<FieldDescriptionData> list, FieldDescriptionData fieldDescriptionData) {
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            FieldDescriptionData fieldDescriptionData2 = list.get(i);
            if (fieldDescriptionData2.fieldNumber != fieldDescriptionData.fieldNumber) continue;
            n = i;
            break;
        }
        return n;
    }

    private static IndexAndCommandType findNextCommand(String string, int n, String string2, CommandType commandType) {
        IndexAndCommandType indexAndCommandType = FormatUtilZpl.findNext(string, "~", n, string2, commandType);
        if (indexAndCommandType.getIndex() == -1) {
            indexAndCommandType = FormatUtilZpl.findNext(ZPLUtilities.ZPL_INTERNAL_FORMAT_PREFIX, ZPLUtilities.ZPL_INTERNAL_COMMAND_PREFIX, n, string2, commandType);
        }
        return indexAndCommandType;
    }

    private static IndexAndCommandType findNext(String string, String string2, int n, String string3, CommandType commandType) {
        String string4 = string + commandType.getId();
        String string5 = string + CommandType.ccCommand.getId();
        String string6 = string2 + CommandType.ccCommand.getId();
        String string7 = string + CommandType.xgCommand.getId() + string4;
        String[] stringArray = new String[]{string4, string5, string6, string7};
        IndexAndCommandType indexAndCommandType = FormatUtilZpl.findSpecifiedCommand(n, string3, stringArray);
        return indexAndCommandType;
    }

    private static IndexAndCommandType findSpecifiedCommand(int n, String string, String[] stringArray) {
        CommandType commandType;
        int n2 = StringUtilities.indexOf(string.toLowerCase(), stringArray, n);
        if (n2 > -1) {
            String string2 = string.substring(n2 + 1, n2 + 3);
            commandType = CommandType.getCommand(string2);
        } else {
            commandType = CommandType.unknownCommand;
        }
        return new IndexAndCommandType(n2, commandType);
    }

    private static FieldDescriptionData parseFnCommand(String string) throws MalformedFormatException {
        FieldDescriptionData fieldDescriptionData = null;
        int n = 0;
        int n2 = string.indexOf(34, n);
        if (n2 == -1) {
            try {
                String string2 = string.trim();
                int n3 = Integer.parseInt(string2);
                if (n3 < 1 || n3 > 9999) {
                    throw new MalformedFormatException("'^FN' integer must be between 1 and 9999");
                }
                fieldDescriptionData = new FieldDescriptionData(n3, null);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedFormatException("'^FN' must be followed by an integer");
            }
        }
        if (n2 + 1 < string.length()) {
            try {
                String string3 = string.substring(n2).trim();
                string3 = StringUtilities.stripQuotes(string3);
                String string4 = string.substring(n, n2).trim();
                int n4 = Integer.parseInt(string4);
                if (n4 < 1 || n4 > 9999) {
                    throw new MalformedFormatException("'^FN' integer must be between 1 and 9999");
                }
                fieldDescriptionData = new FieldDescriptionData(n4, string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedFormatException("'^FN' must be followed by an integer");
            }
        }
        return fieldDescriptionData;
    }

    private void throwExceptionStatusOnly() throws ConnectionException {
        if (this.printerConnection instanceof MultichannelConnection) {
            MultichannelConnection multichannelConnection = (MultichannelConnection)this.printerConnection;
            if (this.isOnlySettingsChannelOpen(multichannelConnection)) {
                throw new ConnectionException("Operation cannot be performed with only the status channel open");
            }
        } else if (this.printerConnection instanceof StatusConnection) {
            throw new ConnectionException("Operation cannot be performed over the status channel");
        }
    }

    private boolean isOnlySettingsChannelOpen(MultichannelConnection multichannelConnection) {
        return multichannelConnection.getStatusChannel().isConnected() && !multichannelConnection.getPrintingChannel().isConnected();
    }
}

