/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.printer.discovery.DiscoveredPrinterNetwork;
import com.zebra.sdk.printer.discovery.DiscoveryPacketDecodeException;
import com.zebra.sdk.printer.discovery.internal.DiscoveryPacketDecoderAdvanced;
import com.zebra.sdk.printer.discovery.internal.DiscoveryPacketDecoderLegacy;
import java.util.Map;

public class DiscoveredPrinterNetworkFactory {
    private static final int DISCOVERY_VERSION_OFFSET = 3;
    private static final int LEGACY_DISCOVERY_VERSION = 3;
    private static final int ADVANCED_DISCOVERY_VERSION = 4;

    private DiscoveredPrinterNetworkFactory() {
    }

    public static DiscoveredPrinterNetwork getDiscoveredPrinterNetwork(byte[] byArray) throws DiscoveryPacketDecodeException {
        DiscoveredPrinterNetwork discoveredPrinterNetwork = null;
        if (byArray == null || byArray.length <= 3) {
            throw new DiscoveryPacketDecodeException("Unable to parse the supplied discovery packet due to an invalid discovery packet length");
        }
        int n = DiscoveredPrinterNetworkFactory.getDiscoveryVersionNumber(byArray);
        if (n == 3) {
            DiscoveryPacketDecoderLegacy discoveryPacketDecoderLegacy = new DiscoveryPacketDecoderLegacy(byArray);
            discoveredPrinterNetwork = discoveryPacketDecoderLegacy.getDiscoveredPrinterNetwork();
        } else if (n == 4) {
            DiscoveryPacketDecoderAdvanced discoveryPacketDecoderAdvanced = new DiscoveryPacketDecoderAdvanced(byArray);
            discoveredPrinterNetwork = discoveryPacketDecoderAdvanced.getDiscoveredPrinterNetworkAdvanced();
        } else {
            throw new DiscoveryPacketDecodeException("Unable to parse the supplied discovery packet due to an invalid discovery packet version");
        }
        return discoveredPrinterNetwork;
    }

    private static int getDiscoveryVersionNumber(byte[] byArray) {
        int n = byArray[3];
        if (n < 0) {
            n += 256;
        }
        return n;
    }

    public static boolean isLinkOsPrinter(DiscoveredPrinter discoveredPrinter) {
        boolean bl = false;
        Map<String, String> map = discoveredPrinter.getDiscoveryDataMap();
        if (map != null && map.containsKey("LINK_OS_MAJOR_VER")) {
            String string = map.get("LINK_OS_MAJOR_VER");
            try {
                int n = Integer.parseInt(string);
                bl = n != 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }
}

