/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.PrinterObjectProperties;
import com.zebra.sdk.printer.internal.PrinterFilePropertiesZpl;
import com.zebra.sdk.settings.internal.JsonValidator;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.JacksonObjectMapperFactory;
import com.zebra.sdk.util.internal.MpfPrinterResponse;
import com.zebra.sdk.util.internal.PrinterFileDescriptor;
import com.zebra.sdk.util.internal.PrinterFilePath;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;

public class MultipartFileSender {
    private Connection connection;
    private List<PrinterFileDescriptor> fileDescriptors;

    public MultipartFileSender(Connection connection, List<PrinterFileDescriptor> list) {
        this.connection = connection;
        this.fileDescriptors = list;
    }

    public static PrinterObjectProperties send(Connection connection, PrinterFileDescriptor printerFileDescriptor) throws ConnectionException {
        ArrayList<PrinterFileDescriptor> arrayList = new ArrayList<PrinterFileDescriptor>();
        arrayList.add(printerFileDescriptor);
        List<PrinterObjectProperties> list = MultipartFileSender.send(connection, arrayList);
        if (list.size() < 1) {
            throw new ConnectionException("No printer response to MPF storage request");
        }
        return list.get(0);
    }

    public static List<PrinterObjectProperties> send(Connection connection, List<PrinterFileDescriptor> list) throws ConnectionException {
        return new MultipartFileSender(connection, list).send();
    }

    private List<PrinterObjectProperties> send() throws ConnectionException {
        if (this.fileDescriptors == null || this.fileDescriptors.isEmpty()) {
            throw new IllegalArgumentException("No files to send");
        }
        this.sendToPrinter(this.buildEntity());
        return this.getPrinterResponse();
    }

    private List<PrinterObjectProperties> getPrinterResponse() throws ConnectionException {
        byte[] byArray = this.connection.sendAndWaitForValidResponse("\r\n".getBytes(), this.connection.getMaxTimeoutForRead(), this.connection.getTimeToWaitForMoreData(), new JsonValidator());
        return MultipartFileSender.getPrinterObjectPropertiesFromJsonData(byArray);
    }

    public static List<PrinterObjectProperties> getPrinterObjectPropertiesFromJsonData(byte[] byArray) {
        ArrayList<PrinterObjectProperties> arrayList = new ArrayList<PrinterObjectProperties>();
        if (byArray != null && byArray.length > 0) {
            TypeReference<List<MpfPrinterResponse>> typeReference = new TypeReference<List<MpfPrinterResponse>>(){};
            try {
                List list = (List)JacksonObjectMapperFactory.getInstance().readValue(byArray, (TypeReference)typeReference);
                for (MpfPrinterResponse mpfPrinterResponse : list) {
                    PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(mpfPrinterResponse.getFilename());
                    arrayList.add(new PrinterFilePropertiesZpl(printerFilePath.getDrive() + ":", printerFilePath.getFileName(), printerFilePath.getExtension().substring(1), mpfPrinterResponse.getSize(), mpfPrinterResponse.getCrc32()));
                }
            }
            catch (JsonParseException jsonParseException) {
            }
            catch (JsonMappingException jsonMappingException) {
            }
            catch (IOException iOException) {
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private HttpEntity buildEntity() {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setMode(HttpMultipartMode.STRICT);
        for (PrinterFileDescriptor printerFileDescriptor : this.fileDescriptors) {
            multipartEntityBuilder.addPart("files", (ContentBody)new InputStreamBody(printerFileDescriptor.getSourceStream(), printerFileDescriptor.getName()));
        }
        return multipartEntityBuilder.build();
    }

    private void sendToPrinter(HttpEntity httpEntity) throws ConnectionException {
        try {
            PrinterOutputStream printerOutputStream = new PrinterOutputStream(this.connection);
            ((OutputStream)printerOutputStream).write("{}".getBytes());
            httpEntity.writeTo((OutputStream)printerOutputStream);
            printerOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    class PrinterOutputStream
    extends OutputStream {
        private Connection connection;

        public PrinterOutputStream(Connection connection) {
            this.connection = connection;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.connection.write(byArray, n, n2);
            }
            catch (ConnectionException connectionException) {
                throw new IOException(connectionException.getLocalizedMessage());
            }
        }

        @Override
        public void write(int n) throws IOException {
            throw new IOException("Unsupported Operation");
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }
    }
}

