/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import java.util.UUID;

public class MultipartFileRequester {
    private Connection connection;
    private String fullFilePath;

    public MultipartFileRequester(Connection connection, String string) {
        this.connection = connection;
        this.fullFilePath = string;
    }

    public static void send(Connection connection, String string) throws ConnectionException {
        new MultipartFileRequester(connection, string).send();
    }

    private void send() throws ConnectionException {
        if (this.fullFilePath == null || this.fullFilePath.isEmpty()) {
            throw new IllegalArgumentException("No file name specified");
        }
        this.sendToPrinter();
    }

    private void sendToPrinter() throws ConnectionException {
        String string = this.generateBoundary();
        String string2 = String.format("{}--%s\r\nContent-Disposition: filename=\"%s\"; action=\"retrieve\"\r\nContent-Type: application/octet-stream\r\nContent-Transfer-Encoding: binary\r\n\r\n\r\n--%s--\r\n\r\n", string, this.fullFilePath, string);
        this.connection.write(string2.getBytes());
    }

    private String generateBoundary() {
        String string = UUID.randomUUID().toString().replaceAll("\\-|\\{|\\}", "Z");
        string = string + string;
        string = string.substring(0, 65);
        return string;
    }
}

