/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.FileWrapper;
import com.zebra.sdk.util.internal.PrinterFileDescriptor;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import com.zebra.sdk.util.internal.StreamHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class FontConverterHelper {
    public static InputStream getFontHeader(InputStream inputStream, String string, char c) {
        try {
            return FontConverterHelper.getFontHeader((int)FontConverterHelper.calculateStreamSize(inputStream), string, c);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public static InputStream getFontHeader(long l, String string, char c) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            String string2 = "" + l;
            byteArrayOutputStream.write(16);
            byteArrayOutputStream.write("DY".getBytes());
            byteArrayOutputStream.write(string.getBytes());
            byteArrayOutputStream.write(31);
            byteArrayOutputStream.write("b".getBytes());
            byteArrayOutputStream.write(31);
            byteArrayOutputStream.write(c);
            byteArrayOutputStream.write(31);
            byteArrayOutputStream.write(string2.getBytes());
            byteArrayOutputStream.write(31);
            byteArrayOutputStream.write(31);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getLocalizedMessage());
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static long calculateStreamSize(InputStream inputStream) throws IOException {
        long l = 0L;
        byte[] byArray = new byte[4096];
        while (inputStream.available() > 0) {
            l += (long)inputStream.read(byArray);
        }
        return l;
    }

    public static void saveFontAsPrinterFont(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        try {
            string = FileUtilities.changeExtension(string, string2);
            if (inputStream instanceof FileInputStream) {
                FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
                PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(fileChannel.size(), "0000", "0000");
                PrinterFileDescriptor printerFileDescriptor = new PrinterFileDescriptor(inputStream, string, printerFileMetadata);
                outputStream.write(FileWrapper.createCisdfHeader(printerFileDescriptor).getBytes());
                StreamHelper.copyAndCloseSourceStream(outputStream, inputStream);
                outputStream.write(FileWrapper.getCisdfTrailer());
                fileChannel.close();
            } else if (inputStream.markSupported()) {
                inputStream.mark(Integer.MAX_VALUE);
                PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(inputStream);
                inputStream.reset();
                PrinterFileDescriptor printerFileDescriptor = new PrinterFileDescriptor(inputStream, string, printerFileMetadata);
                outputStream.write(FileWrapper.createCisdfHeader(printerFileDescriptor).getBytes());
                StreamHelper.copyAndCloseSourceStream(outputStream, inputStream);
                outputStream.write(FileWrapper.getCisdfTrailer());
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while (inputStream.available() > 0) {
                    byteArrayOutputStream.write(inputStream.read());
                }
                PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                PrinterFileDescriptor printerFileDescriptor = new PrinterFileDescriptor(new ByteArrayInputStream("".getBytes()), string, printerFileMetadata);
                outputStream.write(FileWrapper.createCisdfHeader(printerFileDescriptor).getBytes());
                StreamHelper.copyAndCloseSourceStream(outputStream, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                outputStream.write(FileWrapper.getCisdfTrailer());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getLocalizedMessage());
        }
    }
}

