/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.ProgressMonitor;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.util.internal.PrinterFilePath;
import com.zebra.sdk.util.internal.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtilities {
    public static PrinterFilePath parseDriveAndExtension(String string) throws ZebraIllegalArgumentException {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Pattern pattern = Pattern.compile("^(([A-Za-z]+):)?([^.:]+)(\\.[^.]{0,3})?$");
        if (string == null || string.length() <= 0) {
            throw new ZebraIllegalArgumentException("Incorrect file name : ");
        }
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new ZebraIllegalArgumentException("Incorrect file name : " + string);
        }
        string2 = matcher.group(2);
        string3 = FileUtilities.truncateAndReplaceSpaces(matcher.group(3));
        string4 = matcher.group(4);
        return new PrinterFilePath(string2, string3, string4);
    }

    private static String truncateAndReplaceSpaces(String string) {
        return StringUtilities.convertTo16dot3(string).replace(" ", "_");
    }

    public static String changeExtension(String string, String string2) {
        if (!string2.contains(".")) {
            string2 = "." + string2;
        }
        if (string.trim().endsWith(string2)) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string + string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(0, n));
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String GetFileNameOnPrinter(String string) throws ZebraIllegalArgumentException {
        if (string == null) {
            throw new ZebraIllegalArgumentException("Invalid file path");
        }
        String string2 = new File(string).getName();
        if (string2.equals("")) {
            throw new ZebraIllegalArgumentException("Invalid file path");
        }
        return "E:" + StringUtilities.convertTo8dot3(string2).toUpperCase();
    }

    public static void sendFileContentsInChunks(Connection connection, InputStream inputStream) throws ConnectionException {
        if (!connection.isConnected()) {
            throw new ConnectionException("Connection is not open.");
        }
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray);
            while (n > 0) {
                connection.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getMessage());
        }
    }

    public static void sendFileContentsInChunks(Connection connection, ProgressMonitor progressMonitor, InputStream inputStream, int n) throws ConnectionException {
        if (!connection.isConnected()) {
            throw new ConnectionException("Connection is not open.");
        }
        try {
            int n2 = n;
            while (n2 > 0) {
                int n3 = 4096 > n2 ? n2 : 4096;
                byte[] byArray = new byte[n3];
                int n4 = inputStream.read(byArray);
                connection.write(byArray, 0, n4);
                progressMonitor.updateProgress(n - (n2 -= n4), n);
            }
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getMessage());
        }
    }
}

