/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.InflaterInputStream;

public class CustomGZIPInputStream
extends InflaterInputStream {
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean closed = false;
    public static final int GZIP_MAGIC = 35615;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
    }

    public CustomGZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream);
        this.crc.reset();
    }

    public CustomGZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 512);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.eos) {
            return -1;
        }
        if ((n2 = super.read(byArray, n, n2)) == -1) {
            this.eos = true;
        } else {
            this.crc.update(byArray, n, n2);
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.eos = true;
            this.closed = true;
        }
    }
}

