/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.StorageInfo;
import com.zebra.sdk.printer.internal.FileUtilZpl;
import com.zebra.sdk.printer.operations.internal.PrinterOperationCaresAboutLinkOsVersion;
import java.util.List;

public class StorageInfoGrabber
extends PrinterOperationCaresAboutLinkOsVersion<List<StorageInfo>> {
    public StorageInfoGrabber(Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) {
        super(connection, printerLanguage, linkOsInformation);
    }

    @Override
    public List<StorageInfo> execute() throws ConnectionException {
        this.selectProperChannel();
        this.isOkToProceed();
        return this.getStorageInfo();
    }

    private List<StorageInfo> getStorageInfo() throws ConnectionException {
        FileUtilZpl fileUtilZpl = new FileUtilZpl(this.connection);
        List<StorageInfo> list = this.isLinkOs2_5_OrHigher() ? (this.isPrintingChannelInLineMode() ? fileUtilZpl.getStorageInfoViaSgd() : fileUtilZpl.getStorageInfoViaJsonChannel()) : fileUtilZpl.getStorageInfo();
        return list;
    }

    @Override
    protected void selectProperChannel() {
        if (this.isLinkOs2_5_OrHigher()) {
            this.selectStatusChannelIfOpen();
        } else if (this.connection instanceof MultichannelConnection) {
            this.connection = ((MultichannelConnection)this.connection).getPrintingChannel();
        }
    }

    private void isOkToProceed() throws ConnectionException {
        if (!this.isLinkOs2_5_OrHigher()) {
            if (this.connection instanceof StatusConnection) {
                throw new ConnectionException("Cannot retrieve storage info over the status channel on this version of firmware");
            }
            if (this.printerLanguage == PrinterLanguage.LINE_PRINT) {
                throw new ConnectionException("Cannot retrieve storage info when in line print mode on this version of firmware");
            }
            if (!this.connection.isConnected()) {
                throw new ConnectionException("Cannot retrieve storage info when there is no valid connection");
            }
        }
    }
}

