/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.PrinterCommandImpl;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.operations.internal.PrinterOperationBase;
import java.util.List;

public class FileRemover
extends PrinterOperationBase<Void> {
    private static final long serialVersionUID = 4698239072491759650L;
    private List<String> fullPathsToFiles;

    public FileRemover(List<String> list, Connection connection, PrinterLanguage printerLanguage) {
        super(connection, printerLanguage);
        this.fullPathsToFiles = list;
    }

    @Override
    public Void execute() throws ConnectionException {
        this.selectStatusChannelIfOpen();
        this.deleteFiles();
        return null;
    }

    private void deleteFiles() throws ConnectionException {
        for (String string : this.fullPathsToFiles) {
            if (this.isPrintingChannelInLineMode()) {
                SGD.SET("file.delete", string, this.connection);
                continue;
            }
            new PrinterCommandImpl("{}{\"file.delete\" : \"" + string + "\"}").sendAndWaitForValidJsonResponse(this.connection);
        }
    }
}

