/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.comm.internal.PrinterCommandImpl;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.internal.ToolsUtilZpl;
import com.zebra.sdk.printer.operations.internal.PrinterOperationCaresAboutLinkOsVersion;

public class ConfigurationLabelPrinter
extends PrinterOperationCaresAboutLinkOsVersion<Void> {
    private static final long serialVersionUID = -232786459659968863L;

    public ConfigurationLabelPrinter(Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) {
        super(connection, printerLanguage, linkOsInformation);
    }

    @Override
    public Void execute() throws ConnectionException {
        this.selectProperChannel();
        this.isOkToProceed();
        this.printConfigLabel();
        return null;
    }

    private void isOkToProceed() throws ConnectionException {
        if (!(this.isLinkOs2_5_OrHigher() || !(this.connection instanceof StatusConnection) && this.connection.isConnected())) {
            throw new ConnectionException("Cannot print config label over status channel on this version of firmware");
        }
    }

    private void printConfigLabel() throws ConnectionException {
        if (this.isLinkOs2_5_OrHigher()) {
            if (this.isPrintingChannelInLineMode()) {
                this.connection.write("! U1 setvar \"device.print_out_report\" \"settings\"\r\n".getBytes());
            } else {
                new PrinterCommandImpl("{}{\"device.print_out_report\":\"settings\"}").sendAndWaitForValidJsonResponse(this.connection);
            }
        } else {
            new ToolsUtilZpl(this.connection).printConfigurationLabel();
        }
    }
}

