/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.graphics.ZebraImageI;
import com.zebra.sdk.graphics.internal.CompressedBitmapOutputStreamCpcl;
import com.zebra.sdk.graphics.internal.DitheredImageProvider;
import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import com.zebra.sdk.printer.internal.GraphicsConversionUtilCpcl;
import com.zebra.sdk.printer.internal.GraphicsUtilA;
import com.zebra.sdk.printer.internal.PrinterConnectionOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class GraphicsUtilCpcl
extends GraphicsUtilA {
    protected Connection printerConnection;

    public GraphicsUtilCpcl(Connection connection) {
        this.printerConnection = connection;
    }

    @Override
    public void printImage(ZebraImageI zebraImageI, int n, int n2, int n3, int n4, boolean bl) throws ConnectionException {
        ZebraImageInternal zebraImageInternal = this.scaleImage(n3, n4, (ZebraImageInternal)zebraImageI);
        int n5 = (zebraImageI.getWidth() + 7) / 8;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = bl ? "" : "! 0 200 200 " + zebraImageInternal.getHeight() + " 1\r\n";
            String string2 = bl ? "" : "FORM\r\nPRINT\r\n";
            byteArrayOutputStream.write(string.getBytes());
            byteArrayOutputStream.write("CG ".getBytes());
            byteArrayOutputStream.write(String.valueOf(n5).getBytes());
            byteArrayOutputStream.write(" ".getBytes());
            byteArrayOutputStream.write(String.valueOf(zebraImageInternal.getHeight()).getBytes());
            byteArrayOutputStream.write(" ".getBytes());
            byteArrayOutputStream.write(String.valueOf(n).getBytes());
            byteArrayOutputStream.write(" ".getBytes());
            byteArrayOutputStream.write(String.valueOf(n2).getBytes());
            byteArrayOutputStream.write(" ".getBytes());
            this.printerConnection.write(byteArrayOutputStream.toByteArray());
            PrinterConnectionOutputStream printerConnectionOutputStream = new PrinterConnectionOutputStream(this.printerConnection);
            CompressedBitmapOutputStreamCpcl compressedBitmapOutputStreamCpcl = new CompressedBitmapOutputStreamCpcl(printerConnectionOutputStream);
            DitheredImageProvider.getDitheredImage(zebraImageInternal, compressedBitmapOutputStreamCpcl);
            ((OutputStream)compressedBitmapOutputStreamCpcl).close();
            printerConnectionOutputStream.close();
            this.printerConnection.write("\r\n".getBytes());
            this.printerConnection.write(string2.getBytes());
        }
        catch (Exception exception) {
            throw new ConnectionException(exception.getMessage());
        }
    }

    @Override
    public void storeImage(String string, ZebraImageI zebraImageI, int n, int n2) throws ConnectionException, ZebraIllegalArgumentException {
        GraphicsConversionUtilCpcl graphicsConversionUtilCpcl = new GraphicsConversionUtilCpcl();
        PrinterConnectionOutputStream printerConnectionOutputStream = new PrinterConnectionOutputStream(this.printerConnection);
        try {
            graphicsConversionUtilCpcl.sendImageToStream(string, (ZebraImageInternal)zebraImageI, n, n2, printerConnectionOutputStream);
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }
}

