/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.ProgressMonitor;
import com.zebra.sdk.printer.FirmwareUpdateHandlerBase;
import com.zebra.sdk.printer.ZebraPrinterFactory;

public class FirmwareDownloadRunnable
implements Runnable {
    private Connection zebraPrinterConnection;
    private String firmwareFilePath;
    private FirmwareUpdateHandlerBase handler;
    private Exception exceptionCaughtDuringRun = null;

    public FirmwareDownloadRunnable(Connection connection, String string, FirmwareUpdateHandlerBase firmwareUpdateHandlerBase) {
        this.zebraPrinterConnection = connection;
        this.firmwareFilePath = string;
        this.handler = firmwareUpdateHandlerBase;
    }

    @Override
    public void run() {
        block4: {
            try {
                ZebraPrinterFactory.getInstance(this.zebraPrinterConnection).sendFileContents(this.firmwareFilePath, new ProgressMonitor(){

                    @Override
                    public void updateProgress(int n, int n2) {
                        FirmwareDownloadRunnable.this.handler.progressUpdate(n, n2);
                    }
                });
            }
            catch (Exception exception) {
                this.exceptionCaughtDuringRun = exception;
                if (!this.zebraPrinterConnection.isConnected()) break block4;
                try {
                    this.zebraPrinterConnection.close();
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean exceptionOccured() {
        return this.exceptionCaughtDuringRun != null;
    }

    public String getExceptionMessage() {
        return this.exceptionCaughtDuringRun.getMessage();
    }
}

