/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.graphics.internal;

import com.zebra.sdk.graphics.ZebraImageFactory;
import com.zebra.sdk.graphics.internal.DitheredImageProvider;
import com.zebra.sdk.graphics.internal.NaughtyBitOutputStream;
import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class PngToGrfConverterDesktop {
    private static final int DATA_SIZE = 8;

    public static byte[] pngToGrf(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage.getType() != 12) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            NaughtyBitOutputStream naughtyBitOutputStream = new NaughtyBitOutputStream(byteArrayOutputStream);
            DitheredImageProvider.getDitheredImage((ZebraImageInternal)ZebraImageFactory.getImage(bufferedImage), naughtyBitOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        return PngToGrfConverterDesktop.writeFile(bufferedImage);
    }

    private static byte[] writeFile(BufferedImage bufferedImage) {
        Raster raster = bufferedImage.getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = bufferedImage.getWidth() / 8;
        if (bufferedImage.getWidth() % 8 > 0) {
            ++n;
        }
        int n2 = bufferedImage.getHeight();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = PngToGrfConverterDesktop.invert(dataBuffer.getElem(n3++));
                if (j == n - 1) {
                    n4 = PngToGrfConverterDesktop.maskOff(n4, PngToGrfConverterDesktop.getNumBitsToMask(8, bufferedImage.getWidth()));
                }
                byteArrayOutputStream.write(n4);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static int getNumBitsToMask(int n, int n2) {
        return (n - n2 % n) % n;
    }

    private static int maskOff(int n, int n2) {
        return n & (255 << n2 & 0xFF) & 0xFF;
    }

    private static int invert(int n) {
        return ~n & 0xFF;
    }
}

