/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.util.internal.Range;

public class ResetCommand
extends Command {
    private static final Option PRINTER_OPTION = new Option("p", "printer", "Reset the printer");
    private static final Option NETWORK_OPTION = new Option("n", "network", "Reset the network");
    private static final int CONNECTION_ARG_INDEX = 0;

    public ResetCommand() {
        this.options.add(PRINTER_OPTION);
        this.options.add(NETWORK_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.groups.add(new OptionGroup().createGroup(PRINTER_OPTION, NETWORK_OPTION));
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "reset";
    }

    @Override
    public String getDescription() {
        return "Resets a printer";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getArg(0);
        String string2 = this.getConnectionFromArgs(parsedArguments, string);
        if (parsedArguments.containsOption(PRINTER_OPTION)) {
            this.verboseFormatPrint("Resetting printer %s%n", string);
            PrinterUtil.resetPrinter(string2);
        } else if (parsedArguments.containsOption(NETWORK_OPTION)) {
            this.verboseFormatPrint("Resetting network on %s%n", string);
            PrinterUtil.resetNetwork(string2);
        } else {
            this.verbosePrint("No option specified.");
            System.out.println("Please specify printer or network reset.");
        }
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.ONE_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Reset a printer:\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), PRINTER_OPTION.getLongName()));
        stringBuilder.append("Reset the network on a printer: \n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), NETWORK_OPTION.getLongName()));
        stringBuilder.append("Reset a printer via ZDesigner Driver with verbose mode: \n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" --%s --%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), PRINTER_OPTION.getLongName(), ZebraCommandConstants.DRIVER_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Reset a printer via Driverless USB: \n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), PRINTER_OPTION.getLongName()));
        return stringBuilder.toString();
    }
}

