/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionBuilder;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.FirmwareUpdateHandler;
import com.zebra.sdk.printer.NotALinkOsPrinterException;
import com.zebra.sdk.printer.ZebraPrinter;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.internal.FirmwareUpdateHandlerVerboseDecorator;
import com.zebra.sdk.printer.internal.FirmwareUtil;
import com.zebra.sdk.util.internal.Range;
import java.io.FileInputStream;
import java.io.InputStream;

public class FirmwareUpdateCommand
extends Command {
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int FIRMWARE_FILE_INDEX = 1;
    private static final Option TIMEOUT_OPTION = new Option("t", "timeout", "Timeout for the firmware to download, defaults to 180,000 (3 mins)").addArg("mills", true);
    public static final Option FORCE_OPTION = new Option("f", "force", "Update firmware even if the printer is up to date");
    private boolean firmwareDownloadComplete = false;
    private Connection connection = null;

    public FirmwareUpdateCommand() {
        this.options.add(TIMEOUT_OPTION);
        this.options.add(FORCE_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "update";
    }

    @Override
    public String getDescription() {
        return "Updates the firmware on the printer";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        block17: {
            long l = parsedArguments.containsOption(TIMEOUT_OPTION) ? Long.parseLong(parsedArguments.getOptionArgument(TIMEOUT_OPTION)) : 0L;
            String string = this.getConnectionFromArgs(parsedArguments, parsedArguments.getArg(0));
            String string2 = parsedArguments.getArg(1);
            this.verbosePrint("Starting firmware update, this may take a while.");
            this.connection = ConnectionBuilder.build(string);
            this.connection.open();
            try {
                String string3 = FirmwareUtil.getFWVersionFromPrinterConnection(this.connection);
                FileInputStream fileInputStream = new FileInputStream(string2);
                String string4 = FirmwareUtil.extractFirmwareVersion(fileInputStream);
                ((InputStream)fileInputStream).close();
                FileInputStream fileInputStream2 = new FileInputStream(string2);
                boolean bl = parsedArguments.containsOption(FORCE_OPTION) || !FirmwareUtil.firmwareVersionsMatch(string3, string4);
                ((InputStream)fileInputStream2).close();
                if (bl) {
                    ZebraPrinter zebraPrinter = ZebraPrinterFactory.getInstance(this.connection);
                    ZebraPrinterLinkOs zebraPrinterLinkOs = ZebraPrinterFactory.createLinkOsPrinter(zebraPrinter);
                    if (zebraPrinterLinkOs != null) {
                        try {
                            FirmwareUpdateHandler firmwareUpdateHandler = new FirmwareUpdateHandler(){

                                @Override
                                public void printerOnline(ZebraPrinterLinkOs zebraPrinterLinkOs, String string) {
                                    FirmwareUpdateCommand.this.connection = zebraPrinterLinkOs.getConnection();
                                }

                                @Override
                                public void firmwareDownloadComplete() {
                                    FirmwareUpdateCommand.this.firmwareDownloadComplete = true;
                                }

                                @Override
                                public void progressUpdate(int n, int n2) {
                                }
                            };
                            if (string4.isEmpty()) {
                                this.verboseFormatPrint("Updating printer firmware...%n", new Object[0]);
                            } else {
                                this.verboseFormatPrint("Current printer firmware is %s, upgrading to %s...%n", string3, string4);
                            }
                            FirmwareUpdateHandlerVerboseDecorator firmwareUpdateHandlerVerboseDecorator = new FirmwareUpdateHandlerVerboseDecorator(this.isVerbose, string, string2, firmwareUpdateHandler);
                            try {
                                zebraPrinterLinkOs.updateFirmwareUnconditionally(string2, l, firmwareUpdateHandlerVerboseDecorator);
                                break block17;
                            }
                            catch (Exception exception) {
                                System.out.println("Error updating printer firmware.");
                                System.out.println("Please check if your printer is online and try again.");
                                throw exception;
                            }
                        }
                        catch (Exception exception) {
                            if (!this.firmwareDownloadComplete) {
                                this.verboseFormatPrint("%n", new Object[0]);
                            }
                            throw exception;
                        }
                        finally {
                            this.connection.close();
                        }
                    }
                    this.connection.close();
                    throw new NotALinkOsPrinterException();
                }
                this.verboseFormatPrint("Printer is up to date with firmware version %s, not updating printer.%n", string4);
                this.verboseFormatPrint("Send with -f option to send anyways. %n", new Object[0]);
                this.connection.close();
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                this.connection.close();
            }
        }
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <firmwareFile> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Update the firmware on printer at 1.2.3.4\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/firmware.zpl%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Update the firmware via ZDesigner Driver\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" /path/to/firmware.zpl --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("update the firmware via port 6101 and set the timeout to 10 mins\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:6101 /path/to/firmware.zpl --%s 600000%n", "java -jar ZSDK_API.jar", this.getCommandName(), TIMEOUT_OPTION.getLongName()));
        stringBuilder.append("Update the firmware via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" /path/to/firmware.zpl%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

