/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.util.internal.Range;
import java.io.File;

public class StoreFileCommand
extends Command {
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int FILE_ARG_INDEX = 1;
    private static final Option REMOTE_NAME_OPTION = new Option("n", "name", "Store file with name. Will use truncated version of local file otherwise.").addArg("fileName", true);

    public StoreFileCommand() {
        this.options.add(REMOTE_NAME_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "store";
    }

    @Override
    public String getDescription() {
        return "Stores a local file onto a printer.";
    }

    @Override
    public String getDescriptionSupplement() {
        return "If the rename option is not specified, the file name will be the first 16 letters of the local file's name, the first 3 letters of the extension, and stored on the E drive on ZPL printers.";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getArg(1);
        if (!new File(string).exists()) {
            throw new IllegalArgumentException("File does not exist.");
        }
        String string2 = this.getConnectionFromArgs(parsedArguments, parsedArguments.getArg(0));
        String string3 = parsedArguments.getOptionArgument(REMOTE_NAME_OPTION);
        this.verboseFormatPrint("Storing file%n", new Object[0]);
        PrinterUtil.storeFile(string2, string, string3);
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <filePath> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Store local file onto printer\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/local.zpl%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Store a local file onto a printer via ZDesigner Driver and rename\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" /path/to/local.zpl --%s E:REMOTE.ZPL --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), REMOTE_NAME_OPTION.getLongName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("Store a local file onto a printer using port 9100\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/local.zpl --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TCP_OPTION.getLongName()));
        stringBuilder.append("Store a local file onto a printer via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" /path/to/local.zpl%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

