/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.PrinterCommandImpl;
import com.zebra.sdk.printer.PrinterStatus;
import com.zebra.sdk.printer.ZplPrintMode;
import com.zebra.sdk.util.internal.CPCLUtilities;

public class PrinterStatusCpcl
extends PrinterStatus {
    public PrinterStatusCpcl(Connection connection) throws ConnectionException {
        super(connection);
    }

    @Override
    protected void updateStatus() throws ConnectionException {
        PrinterCommandImpl printerCommandImpl = new PrinterCommandImpl(CPCLUtilities.PRINTER_STATUS);
        byte[] byArray = printerCommandImpl.sendAndWaitForResponse(this.printerConnection);
        if (byArray.length != 1) {
            throw new ConnectionException("Malformed status response - unable to determine printer status (received " + byArray.length + " bytes)");
        }
        this.labelsRemainingInBatch = 0;
        this.numberOfFormatsInReceiveBuffer = 0;
        this.isPartialFormatInProgress = false;
        this.isHeadCold = false;
        this.isHeadOpen = (byArray[0] & 4) == 4;
        this.isHeadTooHot = false;
        this.isPaperOut = (byArray[0] & 2) == 2;
        this.isRibbonOut = false;
        this.isReceiveBufferFull = false;
        this.isPaused = false;
        this.labelLengthInDots = 0;
        this.printMode = ZplPrintMode.UNKNOWN;
    }
}

