/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import java.util.EnumSet;
import java.util.Set;

public enum PrinterError {
    NONE(0, 0, "None"),
    MEDIA_OUT(2, 1, "Paper Out"),
    RIBBON_OUT(2, 2, "Ribbon Out"),
    HEAD_OPEN(2, 4, "Head Open"),
    PRINTHEAD_SHUTDOWN(2, 16, "Printhead Shutdown"),
    MOTOR_OVERTEMP(2, 32, "Motor Overtemp"),
    INVALID_HEAD(2, 128, "Invalid Head"),
    THERMISTOR_FAULT(2, 512, "Thermistor Fault"),
    PAPER_FEED_ERROR(2, 16384, "Paper Feed"),
    PAUSED(2, 65536, "Paused"),
    BASIC_RUNTIME_ERROR(2, 0x100000, "Basic Runtime Error"),
    BASIC_FORCED(2, 0x200000, "Basic Forced");

    private final int bitFieldValue;
    private final int segment;
    private final String printErrorString;

    private PrinterError(int n2, int n3, String string2) {
        this.bitFieldValue = n3;
        this.segment = n2;
        this.printErrorString = string2;
    }

    public int bitFieldValue() {
        return this.bitFieldValue;
    }

    public int segment() {
        return this.segment;
    }

    public String toString() {
        return this.printErrorString;
    }

    public static PrinterError intToEnum(int n, int n2) {
        PrinterError[] printerErrorArray;
        PrinterError printerError = NONE;
        for (PrinterError printerError2 : printerErrorArray = PrinterError.values()) {
            if (printerError2.bitFieldValue() != n2 || printerError2.segment() != n) continue;
            printerError = printerError2;
            break;
        }
        return printerError;
    }

    public static Set<PrinterError> getEnumSetFromBitmask(int n, int n2) {
        PrinterError[] printerErrorArray = PrinterError.values();
        EnumSet<PrinterError> enumSet = EnumSet.noneOf(PrinterError.class);
        for (PrinterError printerError : printerErrorArray) {
            if ((n2 & printerError.bitFieldValue()) == 0 || printerError.segment() != n) continue;
            enumSet.add(printerError);
        }
        return enumSet;
    }
}

