/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class DiscoveryUtilities {
    private static final List<String> cardCmdIdValues = new ArrayList<String>(Arrays.asList("zmotif", "epcl", "epcl1", "epcl3"));
    private static final List<String> cardModelPrefixes = new ArrayList<String>(Arrays.asList("zxp", "zc"));

    public static boolean isCardPrinter(DiscoveredPrinter discoveredPrinter) {
        boolean bl = false;
        String string = discoveredPrinter.getDiscoveryDataMap().get("MODEL");
        if (string != null && !string.isEmpty() && (DiscoveryUtilities.hasCardPrinterModelPrefix(string = string.toLowerCase(Locale.US)) || DiscoveryUtilities.isCardPrinterCmdId(discoveredPrinter))) {
            bl = true;
        }
        return bl;
    }

    private static boolean hasCardPrinterModelPrefix(String string) {
        if (string != null && !string.isEmpty()) {
            for (String string2 : cardModelPrefixes) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCardPrinterCmdId(DiscoveredPrinter discoveredPrinter) {
        boolean bl = false;
        String string = discoveredPrinter.getDiscoveryDataMap().get("CMD");
        if (string != null && !string.isEmpty()) {
            bl = cardCmdIdValues.contains(string.toLowerCase(Locale.US));
        }
        return bl;
    }
}

