/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.graphics.internal;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.graphics.internal.CompressedBitmapOutputStreamA;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CompressedBitmapOutputStreamZpl
extends CompressedBitmapOutputStreamA {
    private byte previousByteWritten = 0;
    private int previousByteWrittenRepeatCount = 0;
    private static final int[] charMap = new int[]{380, 360, 340, 320, 300, 280, 260, 240, 220, 200, 180, 160, 140, 120, 100, 80, 60, 40, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
    private static final char[] charVal = new char[]{'y', 'x', 'w', 'v', 'u', 't', 's', 'r', 'q', 'p', 'o', 'n', 'm', 'l', 'k', 'j', 'i', 'h', 'g', 'Y', 'X', 'W', 'V', 'U', 'T', 'S', 'R', 'Q', 'P', 'O', 'N', 'M', 'L', 'K', 'J', 'I', 'H', 'G'};

    public CompressedBitmapOutputStreamZpl(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.internalEncodedBuffer = new ByteArrayOutputStream();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            byte[] byArray2 = this.extractNibblesFromByte(byArray[i]);
            this.writeNibblesToStream(byArray2);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.previousByteWrittenRepeatCount > 0) {
            this.sendBufferedDataToPrinter();
            this.previousByteWrittenRepeatCount = 0;
        }
        super.flush();
    }

    private void writeNibblesToStream(byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            this.writeNibbleToStream(byArray[i]);
        }
    }

    private void writeNibbleToStream(byte by) throws IOException {
        if (this.previousByteWrittenRepeatCount == 0) {
            this.previousByteWritten = by;
            ++this.previousByteWrittenRepeatCount;
        } else if (this.previousByteWritten == by) {
            ++this.previousByteWrittenRepeatCount;
        } else {
            this.sendBufferedDataToPrinter();
            this.previousByteWritten = by;
            this.previousByteWrittenRepeatCount = 1;
        }
    }

    private void sendBufferedDataToPrinter() throws IOException {
        try {
            this.computeAndOutput();
        }
        catch (ConnectionException connectionException) {
            throw new IOException(connectionException.getMessage());
        }
    }

    private void computeAndOutput() throws IOException, ConnectionException {
        if (this.previousByteWrittenRepeatCount > 1) {
            int n;
            int n2 = this.previousByteWrittenRepeatCount / 400;
            int n3 = this.previousByteWrittenRepeatCount % 400;
            for (n = 0; n < n2; ++n) {
                this.bufferAndWrite('z');
            }
            for (n = 0; n < charMap.length; ++n) {
                if (n3 < charMap[n]) continue;
                this.bufferAndWrite(charVal[n]);
                n3 -= charMap[n];
            }
        }
        this.bufferAndWrite(Integer.toHexString(this.previousByteWritten & 0xF).toUpperCase().charAt(0));
    }

    private byte[] extractNibblesFromByte(byte by) {
        byte[] byArray = new byte[]{(byte)(~by >> 4 & 0xF), (byte)(~by & 0xF)};
        return byArray;
    }
}

