/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.ConnectionA;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.IpAddressable;
import com.zebra.sdk.comm.TcpZebraConnectorImpl;
import com.zebra.sdk.comm.internal.ConnectionI;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.comm.internal.TcpConnectionReestablisher;
import com.zebra.sdk.comm.internal.ZebraConnector;
import com.zebra.sdk.util.internal.ReflectionUtil;
import com.zebra.sdk.util.internal.RegexUtil;
import java.util.List;

public class TcpConnection
extends ConnectionA
implements IpAddressable,
ConnectionI {
    public static final int DEFAULT_ZPL_TCP_PORT = 9100;
    public static final int DEFAULT_CPCL_TCP_PORT = 6101;
    public boolean isCardPrinter = false;
    public String serialNumber = "";

    protected TcpConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        String string = connectionInfo.getMyData();
        String string2 = "^\\s*((?i)" + this.getConnectionBuilderPrefix() + ":)?([\\d]{1,3}.[\\d]{1,3}.[\\d]{1,3}.[\\d]{1,3})(:([\\d]{1,5}))?\\s*$";
        List<String> list = RegexUtil.getMatches(string2, string);
        if (list.isEmpty()) {
            if (string.contains("zebra.com/apps/r/nfc?") && string.contains("mB=")) {
                throw new NotMyConnectionDataException("TCP Connection doesn't understand " + string);
            }
            String string3 = "^\\s*((?i)" + this.getConnectionBuilderPrefix() + ":)?([^:]+)(:([\\d]{1,5}))?\\s*$";
            list = RegexUtil.getMatches(string3, string);
            if (list.isEmpty()) {
                throw new NotMyConnectionDataException(this.getConnectionBuilderPrefix() + " Connection doesn't understand " + string);
            }
        }
        string = list.get(2);
        int n = this.getDefaultPort();
        try {
            n = Integer.parseInt(list.get(4));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.zebraConnector = new TcpZebraConnectorImpl(string, n);
        this.maxTimeoutForRead = 5000;
        this.timeToWaitForMoreData = 500;
    }

    protected int getDefaultPort() {
        return 9100;
    }

    protected String getConnectionBuilderPrefix() {
        return "TCP";
    }

    public TcpConnection(String string, int n) {
        this(string, n, 5000, 500);
    }

    public TcpConnection(String string, int n, int n2, int n3) {
        this(new TcpZebraConnectorImpl(string, n), n2, n3);
    }

    private TcpConnection(ZebraConnector zebraConnector, int n, int n2) {
        this.zebraConnector = zebraConnector;
        this.maxTimeoutForRead = n;
        this.timeToWaitForMoreData = n2;
    }

    @Override
    public String toString() {
        return "TCP:" + this.getAddress() + ":" + this.getPortNumber();
    }

    @Override
    public String getSimpleConnectionName() {
        return this.getAddress();
    }

    @Override
    public String getAddress() {
        return ((TcpZebraConnectorImpl)this.zebraConnector).getAddress();
    }

    @Override
    public String getPortNumber() {
        return String.valueOf(((TcpZebraConnectorImpl)this.zebraConnector).getPort());
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        if (this.isCardPrinter) {
            return ReflectionUtil.loadTcpCardConnectionReestablisher(this, l);
        }
        return new TcpConnectionReestablisher(this, l);
    }
}

