/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.ConnectionWithWriteLogging;
import com.zebra.sdk.comm.ResponseValidator;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.comm.StatusConnectionWithWriteLogging;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class MultichannelConnection
implements ConnectionWithWriteLogging {
    protected ConnectionWithWriteLogging raw;
    protected StatusConnectionWithWriteLogging settings;

    protected MultichannelConnection() {
    }

    @Override
    public void open() throws ConnectionException {
        boolean bl = false;
        try {
            this.openPrintingChannel();
            bl = true;
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        try {
            this.openStatusChannel();
            bl = true;
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        if (!bl) {
            throw new ConnectionException("Could not open connection");
        }
    }

    public void openPrintingChannel() throws ConnectionException {
        this.raw.open();
    }

    public void openStatusChannel() throws ConnectionException {
        this.settings.open();
    }

    @Override
    public void close() throws ConnectionException {
        this.raw.close();
        this.settings.close();
    }

    public void closePrintingChannel() throws ConnectionException {
        this.raw.close();
    }

    public void closeStatusChannel() throws ConnectionException {
        this.settings.close();
    }

    @Override
    public void write(byte[] byArray) throws ConnectionException {
        this.throwIfOnlyStatusOpen();
        this.raw.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws ConnectionException {
        this.throwIfOnlyStatusOpen();
        this.raw.write(byArray, n, n2);
    }

    @Override
    public void write(InputStream inputStream) throws ConnectionException {
        this.throwIfOnlyStatusOpen();
        this.raw.write(inputStream);
    }

    @Override
    public byte[] read() throws ConnectionException {
        return this.raw.read();
    }

    @Override
    public void read(OutputStream outputStream) throws ConnectionException {
        this.raw.read(outputStream);
    }

    @Override
    public int readChar() throws ConnectionException {
        return this.raw.readChar();
    }

    @Override
    public boolean isConnected() {
        return this.raw.isConnected() || this.settings.isConnected();
    }

    @Override
    public int bytesAvailable() throws ConnectionException {
        return this.raw.bytesAvailable();
    }

    @Override
    public void waitForData(int n) throws ConnectionException {
        this.raw.waitForData(n);
    }

    @Override
    public int getMaxTimeoutForRead() {
        return this.raw.getMaxTimeoutForRead();
    }

    @Override
    public int getTimeToWaitForMoreData() {
        return this.raw.getTimeToWaitForMoreData();
    }

    @Override
    public void setMaxTimeoutForRead(int n) {
        this.raw.setMaxTimeoutForRead(n);
        this.settings.setMaxTimeoutForRead(n);
    }

    @Override
    public void setTimeToWaitForMoreData(int n) {
        this.raw.setTimeToWaitForMoreData(n);
        this.settings.setTimeToWaitForMoreData(n);
    }

    @Override
    public byte[] sendAndWaitForResponse(byte[] byArray, int n, int n2, String string) throws ConnectionException {
        this.throwIfOnlyStatusOpen();
        return this.raw.sendAndWaitForResponse(byArray, n, n2, string);
    }

    @Override
    public void sendAndWaitForResponse(OutputStream outputStream, InputStream inputStream, int n, int n2, String string) throws ConnectionException {
        this.throwIfOnlyStatusOpen();
        this.raw.sendAndWaitForResponse(outputStream, inputStream, n, n2, string);
    }

    @Override
    public byte[] sendAndWaitForValidResponse(byte[] byArray, int n, int n2, ResponseValidator responseValidator) throws ConnectionException {
        this.throwIfOnlyStatusOpen();
        return this.raw.sendAndWaitForValidResponse(byArray, n, n2, responseValidator);
    }

    @Override
    public void sendAndWaitForValidResponse(OutputStream outputStream, InputStream inputStream, int n, int n2, ResponseValidator responseValidator) throws ConnectionException {
        this.throwIfOnlyStatusOpen();
        this.raw.sendAndWaitForValidResponse(outputStream, inputStream, n, n2, responseValidator);
    }

    public Connection getPrintingChannel() {
        return this.raw;
    }

    public StatusConnection getStatusChannel() {
        return this.settings;
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        return this.raw.getConnectionReestablisher(l);
    }

    @Override
    public void addWriteLogStream(OutputStream outputStream) {
        this.raw.addWriteLogStream(outputStream);
        this.settings.addWriteLogStream(outputStream);
    }

    private void throwIfOnlyStatusOpen() throws ConnectionException {
        if (!this.raw.isConnected() && this.settings.isConnected()) {
            throw new ConnectionException("Operation cannot be performed with only the status channel open");
        }
    }
}

