/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.certificate;

import com.zebra.sdk.certificate.ZebraCertificateException;
import com.zebra.sdk.certificate.internal.CertUtilitiesFactory;
import com.zebra.sdk.certificate.internal.CertUtilitiesI;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.crypto.BadPaddingException;

public class ZebraP12Info {
    private KeyStore keyStore = null;
    private String firstAlias = "";

    public ZebraP12Info(InputStream inputStream, String string) throws ZebraCertificateException {
        try {
            this.keyStore = this.getPkcs12KeyStore(inputStream, string);
            this.firstAlias = this.keyStore.aliases().nextElement();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ZebraCertificateException("The provided password was incorrect.", illegalArgumentException);
        }
        catch (IOException iOException) {
            String string2 = "The provided certificate file was invalid.";
            if (iOException.getLocalizedMessage().toLowerCase(Locale.US).contains("password")) {
                string2 = "The provided password was incorrect.";
            }
            throw new ZebraCertificateException(string2, iOException);
        }
        catch (Exception exception) {
            throw new ZebraCertificateException("The provided stream does not appear to contain valid certificate content or the password is incorrect.", exception);
        }
    }

    public List<String> getAliases() throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<String> enumeration = null;
        try {
            enumeration = this.keyStore.aliases();
        }
        catch (KeyStoreException keyStoreException) {
            throw new ZebraCertificateException("The certificate file was not valid.", keyStoreException);
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public String getCertificateContent() throws ZebraCertificateException {
        return this.getCertificateContent(this.firstAlias);
    }

    public String getCertificateContent(String string) throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        if (!this.getAliases().contains(string)) {
            throw new ZebraCertificateException("The provided alias \"" + string + "\" was not found in the provided keystore.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            CertUtilitiesI certUtilitiesI = CertUtilitiesFactory.getCertUtilities();
            certUtilitiesI.getCertificateFromPkcs12Keystore(string, byteArrayOutputStream, this.keyStore);
        }
        catch (IOException iOException) {
            throw new ZebraCertificateException("Failed to retrieve the certificate contents", iOException);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    public String getCaContent() throws ZebraCertificateException {
        return this.getCaContent(this.firstAlias);
    }

    public String getCaContent(String string) throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        if (!this.getAliases().contains(string)) {
            throw new ZebraCertificateException("The provided alias \"" + string + "\" was not found in the provided keystore.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            CertUtilitiesFactory.getCertUtilities().getCaFromPkcs12Keystore(string, byteArrayOutputStream, this.keyStore);
        }
        catch (IOException iOException) {
            throw new ZebraCertificateException("Failed to retrieve the ca contents", iOException);
        }
        String string2 = new String(byteArrayOutputStream.toByteArray());
        if (string2 == null || string2.isEmpty()) {
            throw new ZebraCertificateException("The provided certificate file does not contain a ca.");
        }
        return string2;
    }

    public String getEncryptedPrivateKeyContent(String string, String string2) throws ZebraCertificateException {
        return this.getEncryptedPrivateKeyContent(this.firstAlias, string, string2);
    }

    public String getEncryptedPrivateKeyContent(String string, String string2, String string3) throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        if (!this.getAliases().contains(string)) {
            throw new ZebraCertificateException("The provided alias \"" + string + "\" was not found in the provided keystore.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            CertUtilitiesFactory.getCertUtilities().getPrivateKeyFromPkcs12Keystore(string, string3, string2, byteArrayOutputStream, this.keyStore);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new ZebraCertificateException("Could not recover the key from the provided certificate keystore.", unrecoverableKeyException);
        }
        catch (IOException iOException) {
            throw new ZebraCertificateException("Failed to retrieve the private key contents", iOException);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    private KeyStore getPkcs12KeyStore(InputStream inputStream, String string) throws KeyStoreException, IOException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        if (string == null) {
            string = "";
        }
        try {
            keyStore.load(inputStream, string.toCharArray());
        }
        catch (Exception exception) {
            if (exception.getCause() != null && exception.getCause() instanceof BadPaddingException) {
                throw new IllegalArgumentException("The provided password was incorrect.", exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IllegalArgumentException("Failed to read contents of the certificate file - make sure that the provided password is correct.", exception);
        }
        return keyStore;
    }

    public String getCertificateCommonName() throws ZebraCertificateException {
        return this.getCertificateCommonName(this.firstAlias);
    }

    public String getCertificateCommonName(String string) throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        if (!this.getAliases().contains(string)) {
            throw new ZebraCertificateException("The provided alias \"" + string + "\" was not found in the provided keystore.");
        }
        Certificate[] certificateArray = CertUtilitiesFactory.getCertUtilities().getCertificateChain(string, this.keyStore);
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        String string2 = "";
        try {
            string2 = CertUtilitiesFactory.getCertificateHelper().getCommonNameHelper(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new ZebraCertificateException("The certificate could not be parsed for a common name.", certificateEncodingException);
        }
        return string2;
    }

    public String getCaCommonName() throws ZebraCertificateException {
        return this.getCaCommonName(this.firstAlias);
    }

    public String getCaCommonName(String string) throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        if (!this.getAliases().contains(string)) {
            throw new ZebraCertificateException("The provided alias \"" + string + "\" was not found in the provided keystore.");
        }
        Certificate[] certificateArray = CertUtilitiesFactory.getCertUtilities().getCertificateChain(string, this.keyStore);
        X509Certificate x509Certificate = (X509Certificate)certificateArray[certificateArray.length - 1];
        String string2 = "";
        try {
            string2 = CertUtilitiesFactory.getCertificateHelper().getCommonNameHelper(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new ZebraCertificateException("The certificate could not be parsed for a common name.", certificateEncodingException);
        }
        return string2;
    }

    public Date getCertificateExpirationDate() throws ZebraCertificateException {
        return this.getCertificateExpirationDate(this.firstAlias);
    }

    public Date getCertificateExpirationDate(String string) throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        if (!this.getAliases().contains(string)) {
            throw new ZebraCertificateException("The provided alias \"" + string + "\" was not found in the provided keystore.");
        }
        Certificate[] certificateArray = CertUtilitiesFactory.getCertUtilities().getCertificateChain(string, this.keyStore);
        return ((X509Certificate)certificateArray[0]).getNotAfter();
    }

    public Date getCaExpirationDate() throws ZebraCertificateException {
        return this.getCertificateExpirationDate(this.firstAlias);
    }

    public Date getCaExpirationDate(String string) throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        if (!this.getAliases().contains(string)) {
            throw new ZebraCertificateException("The provided alias \"" + string + "\" was not found in the provided keystore.");
        }
        Certificate[] certificateArray = CertUtilitiesFactory.getCertUtilities().getCertificateChain(string, this.keyStore);
        return ((X509Certificate)certificateArray[certificateArray.length - 1]).getNotAfter();
    }

    public String getPrivateKeyAlgorithm(String string) throws ZebraCertificateException {
        return this.getPrivateKeyAlgorithm(this.firstAlias, string);
    }

    public String getPrivateKeyAlgorithm(String string, String string2) throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        if (!this.getAliases().contains(string)) {
            throw new ZebraCertificateException("The provided alias \"" + string + "\" was not found in the provided keystore.");
        }
        try {
            PrivateKey privateKey = CertUtilitiesFactory.getCertUtilities().getPrivateKey(string, string2, this.keyStore);
            return privateKey.getAlgorithm();
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new ZebraCertificateException("Could not recover the key from the provided certificate keystore.", unrecoverableKeyException);
        }
    }

    public String getPrivateKeyFormat(String string) throws ZebraCertificateException {
        return this.getPrivateKeyFormat(this.firstAlias, string);
    }

    public String getPrivateKeyFormat(String string, String string2) throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        if (!this.getAliases().contains(string)) {
            throw new ZebraCertificateException("The provided alias \"" + string + "\" was not found in the provided keystore.");
        }
        try {
            PrivateKey privateKey = CertUtilitiesFactory.getCertUtilities().getPrivateKey(string, string2, this.keyStore);
            return privateKey.getFormat();
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new ZebraCertificateException("Could not recover the key from the provided certificate keystore.", unrecoverableKeyException);
        }
    }

    public String getCertificateIssuer() throws ZebraCertificateException {
        return this.getCertificateIssuer(this.firstAlias);
    }

    public String getCertificateIssuer(String string) throws ZebraCertificateException {
        if (this.keyStore == null) {
            throw new ZebraCertificateException("The certificate file was not valid.");
        }
        if (!this.getAliases().contains(string)) {
            throw new ZebraCertificateException("The provided alias \"" + string + "\" was not found in the provided keystore.");
        }
        Certificate[] certificateArray = CertUtilitiesFactory.getCertUtilities().getCertificateChain(string, this.keyStore);
        return ((X509Certificate)certificateArray[0]).getIssuerX500Principal().getName();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }
}

