/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.graphics.internal.CompressedBitmapOutputStreamZpl;
import com.zebra.sdk.graphics.internal.DitheredImageProvider;
import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import com.zebra.sdk.printer.internal.GraphicsConvertionUtil;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.PrinterFilePath;
import com.zebra.sdk.util.internal.ZCRC16;
import com.zebra.sdk.util.internal.ZPLUtilities;
import java.io.IOException;
import java.io.OutputStream;

public class GraphicsConversionUtilZpl
implements GraphicsConvertionUtil {
    @Override
    public void sendImageToStream(String string, ZebraImageInternal zebraImageInternal, int n, int n2, OutputStream outputStream) throws ZebraIllegalArgumentException, IOException {
        if (zebraImageInternal == null) {
            throw new ZebraIllegalArgumentException("Invalid image file.");
        }
        zebraImageInternal.scaleImage(n, n2);
        int n3 = (zebraImageInternal.getWidth() + 7) / 8;
        int n4 = n3 * zebraImageInternal.getHeight();
        PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(string);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = GraphicsConversionUtilZpl.getCorrectedFileName(printerFilePath);
        if (printerFilePath.getExtension() != null && printerFilePath.getExtension().equalsIgnoreCase(".PNG")) {
            byte[] byArray = zebraImageInternal.getDitheredB64EncodedPng();
            stringBuilder.append("~DY");
            stringBuilder.append(string2.substring(0, string2.indexOf(46)));
            stringBuilder.append(",p,p,");
            stringBuilder.append(byArray.length);
            stringBuilder.append(",");
            stringBuilder.append(",:B64:");
            String string3 = stringBuilder.toString();
            String string4 = ZPLUtilities.replaceAllWithInternalCharacters(string3);
            outputStream.write(string4.getBytes());
            outputStream.write(byArray);
            outputStream.write(new byte[]{58});
            outputStream.write(ZCRC16.getCRC16ForZpl(new String(byArray)).getBytes());
        } else {
            stringBuilder.append("~DG");
            stringBuilder.append(string2);
            stringBuilder.append(",");
            stringBuilder.append(n4);
            stringBuilder.append(",");
            stringBuilder.append(n3);
            stringBuilder.append(",");
            String string5 = stringBuilder.toString();
            String string6 = ZPLUtilities.replaceAllWithInternalCharacters(string5);
            outputStream.write(string6.getBytes());
            this.writeImageDataToStream(zebraImageInternal, outputStream);
        }
    }

    private static String getCorrectedFileName(PrinterFilePath printerFilePath) throws ZebraIllegalArgumentException {
        String string = printerFilePath.getDrive();
        String string2 = printerFilePath.getFileName();
        String string3 = printerFilePath.getExtension();
        if (string3 == null || !string3.equalsIgnoreCase(".PNG")) {
            string3 = ".GRF";
        }
        if (string == null || string.length() == 0) {
            string = "E";
        } else if (string.length() > 1) {
            throw new ZebraIllegalArgumentException("Invalid drive specified : " + string);
        }
        return string + ":" + string2 + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImageDataToStream(ZebraImageInternal zebraImageInternal, OutputStream outputStream) throws IOException {
        CompressedBitmapOutputStreamZpl compressedBitmapOutputStreamZpl = null;
        try {
            compressedBitmapOutputStreamZpl = new CompressedBitmapOutputStreamZpl(outputStream);
            DitheredImageProvider.getDitheredImage(zebraImageInternal, compressedBitmapOutputStreamZpl);
        }
        finally {
            if (compressedBitmapOutputStreamZpl != null) {
                try {
                    ((OutputStream)compressedBitmapOutputStreamZpl).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

