/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.graphics.internal;

import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import java.io.IOException;
import java.io.OutputStream;

public class DitheredImageProvider {
    public static void getDitheredImage(ZebraImageInternal zebraImageInternal, OutputStream outputStream) throws IOException {
        int n = zebraImageInternal.getWidth();
        int n2 = zebraImageInternal.getHeight();
        DitheredImageProvider.getDitheredImage(n, n2, zebraImageInternal, outputStream);
    }

    protected static void getDitheredImage(int n, int n2, ZebraImageInternal zebraImageInternal, OutputStream outputStream) throws IOException {
        int n3;
        int[] nArray = zebraImageInternal.getRow(0);
        int[] nArray2 = zebraImageInternal.getRow(1);
        int n4 = n / 8 + (n % 8 == 0 ? 0 : 1);
        int n5 = 8 - n % 8;
        if (n5 == 8) {
            n5 = 0;
        }
        byte[] byArray = new byte[n4];
        int n6 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3] = DitheredImageProvider.convertByteToGrayscale(nArray[n3]);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n7;
            for (n7 = 0; n7 < byArray.length; ++n7) {
                byArray[n7] = 0;
            }
            n7 = 0;
            for (int i = 0; i < n; ++i) {
                if (i % 8 == 0) {
                    n6 = -128;
                }
                int n8 = nArray[i];
                n7 = i / 8;
                int n9 = n8 >= 128 ? -1 : 0;
                byArray[n7] = (byte)(byArray[n7] | n6 & n9);
                int n10 = n8 - (n9 & 0xFF);
                if (i < n - 1) {
                    nArray[i + 1] = nArray[i + 1] + 7 * n10 / 16;
                }
                if (i > 0 && n3 < n2 - 1) {
                    nArray2[i - 1] = nArray2[i - 1] + 3 * n10 / 16;
                }
                if (n3 < n2 - 1) {
                    if (i == 0) {
                        nArray2[i] = DitheredImageProvider.convertByteToGrayscale(nArray2[i]);
                    }
                    nArray2[i] = nArray2[i] + 5 * n10 / 16;
                }
                if (n3 < n2 - 1 && i < n - 1) {
                    nArray2[i + 1] = DitheredImageProvider.convertByteToGrayscale(nArray2[i + 1]);
                    nArray2[i + 1] = nArray2[i + 1] + 1 * n10 / 16;
                }
                n6 = (byte)((n6 & 0xFF) >>> 1);
            }
            byArray[n7] = (byte)(byArray[n7] | 255 >>> 8 - n5);
            outputStream.write(byArray);
            nArray = nArray2;
            nArray2 = zebraImageInternal.getRow(n3 + 2);
        }
    }

    private static int convertByteToGrayscale(int n) {
        int n2 = (n & 0xFF0000) >>> 16;
        int n3 = (n & 0xFF00) >>> 8;
        int n4 = n & 0xFF;
        int n5 = (n2 * 30 + n3 * 59 + n4 * 11) / 100;
        if (n5 > 255) {
            n5 = 255;
        } else if (n5 < 0) {
            n5 = 0;
        }
        return n5;
    }
}

